% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed.R, R/embed_url.R, R/service-box.R,
%   R/service-channel9.R, R/service-msstream.R, R/service-vimeo.R,
%   R/service-youtube.R
\name{embed}
\alias{embed}
\alias{embed_user2016}
\alias{embed_user2017}
\alias{embed_box}
\alias{embed_channel9}
\alias{embed_msstream}
\alias{embed_vimeo}
\alias{embed_youtube}
\title{Embed video from service}
\usage{
embed_user2016(
  id,
  width = NULL,
  height = 300,
  ratio = c("16by9", "4by3"),
  frameborder = 0,
  allowfullscreen = TRUE
)

embed_user2017(
  id,
  width = NULL,
  height = 300,
  ratio = c("16by9", "4by3"),
  frameborder = 0,
  allowfullscreen = TRUE
)

embed_box(
  id,
  custom_domain = getOption("vembedr.box_custom_domain"),
  width = NULL,
  height = 300,
  ratio = c("16by9", "4by3"),
  frameborder = 0,
  allowfullscreen = TRUE
)

embed_channel9(
  id,
  width = NULL,
  height = 300,
  ratio = c("16by9", "4by3"),
  frameborder = 0,
  allowfullscreen = TRUE
)

embed_msstream(
  id,
  width = NULL,
  height = 300,
  ratio = c("16by9", "4by3"),
  query = NULL
)

embed_vimeo(
  id,
  width = NULL,
  height = 300,
  ratio = c("16by9", "4by3"),
  frameborder = 0,
  allowfullscreen = TRUE,
  query = NULL,
  fragment = NULL
)

embed_youtube(
  id,
  width = NULL,
  height = 300,
  ratio = c("16by9", "4by3"),
  frameborder = 0,
  allowfullscreen = TRUE,
  query = NULL
)
}
\arguments{
\item{id}{\code{character}, identifier provided by the service}

\item{width}{\code{numeric}, width of iframe (px)}

\item{height}{\code{numeric}, height of iframe (px)}

\item{ratio}{\code{character}, indicates aspect ratio for the \verb{<iframe/>}}

\item{frameborder}{\code{numeric}, size of frame border (px)}

\item{allowfullscreen}{\code{logical}, indicates if to allow fullscreen}

\item{custom_domain}{\code{character}, (used by Box) name of Box-instance
to use. It can be useful to use \code{getOption("vembedr.box_custom_domain")}
if you are using a corporate instance of Box. If \code{NULL}, it will use
the standard Box instance.}

\item{query}{\code{list}, items to include in url-query string}

\item{fragment}{\code{character}, string to include as url-fragment}
}
\value{
Object with S3 class \code{vembedr_embed}
}
\description{
These functions are used to embed video into your \strong{rmarkdown} html-documents,
or into your \strong{shiny} apps. There are functions to embed from
YouTube, Vimeo, Microsoft Channel 9 (who host the UseR! 2016 videos), and Box.
}
\details{
These services allow you to customize a lot of things by specifying
an optional query string. The specification for the query string will differ
according to the service being used:

\describe{
\item{YouTube}{\url{https://developers.google.com/youtube/player_parameters}}
\item{Vimeo}{\url{https://developer.vimeo.com/player/embedding}}
\item{Microsoft Channel 9}{\url{https://channel9.msdn.com/Events/useR-international-R-User-conference/useR2016/Forty-years-of-S}
(click the \emph{Embed} tab)}
\item{Box}{\url{https://developer.box.com/docs/box-embed#section-build-box-embed-programatically}}
\item{Microsoft Stream}{\url{https://docs.microsoft.com/en-us/stream/portal-embed-video}}
}
}
\examples{
embed_youtube("dQw4w9WgXcQ")
embed_vimeo("45196609")
embed_user2016("Literate-Programming")
embed_user2017("Room-202-Lightning-Talks") \%>\% use_start_time("26m35s")
embed_box("m5do45hvzw32iv2aors3urf5pgkxxazx")
embed_msstream("ae21b0ac-4a2b-41f4-b3fc-f1720dd20f48")

}
\seealso{
\code{\link[=use_start_time]{use_start_time()}}
}
\concept{embed}
