% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treePlot.R
\name{plotSelections}
\alias{plotSelections}
\title{plotting function to investigate hierarchical structure of selection}
\usage{
plotSelections(object, s = NULL, type = c("d3.tree"), ...)
}
\arguments{
\item{object}{fitted vennLasso object}

\item{s}{lambda value for the predictions. Only one can be specified at a time}

\item{type}{type of plot to make. Currently only "d3.tree" and "igraph.tree" available}

\item{...}{other graphical parameters for the plot}
}
\description{
plotting function to investigate hierarchical structure of selection
}
\examples{
set.seed(123)

dat.sim <- genHierSparseData(ncats = 3, nvars = 25, nobs = 200)

fit <- vennLasso(x = dat.sim$x, y = dat.sim$y, groups = dat.sim$group.ind)

plotSelections(fit, s = fit$lambda[32])


}
