# create Dockerfile with packages

    Code
      cat(readr::read_lines(file.path(tmp_dir, "Dockerfile")), sep = "\n")
    Output
      # Generated by the vetiver package; edit with care
      
      FROM rocker/r-ver:<r_version>
      ENV RENV_CONFIG_REPOS_OVERRIDE https://packagemanager.rstudio.com/cran/latest
      
      RUN apt-get update -qq && apt-get install -y --no-install-recommends \
        git \
        libcurl4-openssl-dev \
        libgit2-dev \
        libicu-dev \
        libsodium-dev \
        libssl-dev \
        make \
        zlib1g-dev
      
      COPY <redacted>/renv.lock renv.lock
      RUN Rscript -e "install.packages('renv')"
      RUN Rscript -e "renv::restore()"
      COPY <redacted>/plumber.R /opt/ml/plumber.R
      
      ENTRYPOINT ["R", "-e", "pr <- plumber::plumb('/opt/ml/plumber.R'); pr$run(host = '0.0.0.0', port = 8000)"]

# create Dockerfile with no RSPM

    Code
      cat(readr::read_lines(file.path(tmp_dir, "Dockerfile")), sep = "\n")
    Output
      # Generated by the vetiver package; edit with care
      
      FROM rocker/r-ver:<r_version>
      
      RUN apt-get update -qq && apt-get install -y --no-install-recommends \
        git \
        libcurl4-openssl-dev \
        libgit2-dev \
        libicu-dev \
        libsodium-dev \
        libssl-dev \
        make \
        zlib1g-dev
      
      COPY <redacted>/renv.lock renv.lock
      RUN Rscript -e "install.packages('renv')"
      RUN Rscript -e "renv::restore()"
      COPY <redacted>/plumber.R /opt/ml/plumber.R
      
      ENTRYPOINT ["R", "-e", "pr <- plumber::plumb('/opt/ml/plumber.R'); pr$run(host = '0.0.0.0', port = 8000)"]

# create Dockerfile with no packages

    Code
      cat(readr::read_lines(file.path(tmp_dir, "Dockerfile")), sep = "\n")
    Output
      # Generated by the vetiver package; edit with care
      
      FROM rocker/r-ver:<r_version>
      ENV RENV_CONFIG_REPOS_OVERRIDE https://packagemanager.rstudio.com/cran/latest
      
      RUN apt-get update -qq && apt-get install -y --no-install-recommends \
        git \
        libcurl4-openssl-dev \
        libgit2-dev \
        libicu-dev \
        libsodium-dev \
        libssl-dev \
        make
      
      COPY <redacted>/renv.lock renv.lock
      RUN Rscript -e "install.packages('renv')"
      RUN Rscript -e "renv::restore()"
      COPY <redacted>/plumber.R /opt/ml/plumber.R
      
      ENTRYPOINT ["R", "-e", "pr <- plumber::plumb('/opt/ml/plumber.R'); pr$run(host = '0.0.0.0', port = 8000)"]

# create Dockerfile with specific port

    Code
      cat(readr::read_lines(file.path(tmp_dir, "Dockerfile")), sep = "\n")
    Output
      # Generated by the vetiver package; edit with care
      
      FROM rocker/r-ver:<r_version>
      ENV RENV_CONFIG_REPOS_OVERRIDE https://packagemanager.rstudio.com/cran/latest
      
      RUN apt-get update -qq && apt-get install -y --no-install-recommends \
        git \
        libcurl4-openssl-dev \
        libgit2-dev \
        libicu-dev \
        libsodium-dev \
        libssl-dev \
        make \
        zlib1g-dev
      
      COPY <redacted>/renv.lock renv.lock
      RUN Rscript -e "install.packages('renv')"
      RUN Rscript -e "renv::restore()"
      COPY <redacted>/plumber.R /opt/ml/plumber.R
      
      ENTRYPOINT ["R", "-e", "pr <- plumber::plumb('/opt/ml/plumber.R'); pr$run(host = '0.0.0.0', port = as.numeric(Sys.getenv("PORT")))"]

