% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winik.R
\docType{class}
\name{winik}
\alias{winik}
\title{Winik}
\description{
This is an object that represents a villager (winik).
}
\details{
This class acts as an abstraction for handling villager-level logic. It can take a
number of functions that run at each timestep. It also has an associated
}
\section{Methods}{

\describe{
\item{\code{as_table()}}{Represents the current state of the winik as a tibble}
\item{\code{get_age()}}{Returns age in terms of years}
\item{\code{get_gender()}}{}
\item{\code{get_days_sincelast_birth()}}{Get the number of days since the winik last gave birth}
\item{\code{initialize()}}{Create a new winik}
\item{\code{propagate()}}{Runs every day}
}
Create a new winik
}

\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{identifier}}{A unique identifier that can be used to identify and find the winik}

\item{\code{first_name}}{The winik's first name}

\item{\code{last_name}}{The winik's last name}

\item{\code{age}}{The winik's age}

\item{\code{mother_id}}{The identifier of the winik's mother}

\item{\code{father_id}}{The identifier of the winik's father}

\item{\code{profession}}{The winik's profession}

\item{\code{partner}}{The identifier of the winik's partner}

\item{\code{gender}}{The winik's gender}

\item{\code{alive}}{A boolean flag that represents whether the villager is alive or dead}

\item{\code{children}}{A list of children identifiers}

\item{\code{health}}{A percentage value of the winik's current health}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{winik$new()}}
\item \href{#method-is_alive}{\code{winik$is_alive()}}
\item \href{#method-get_days_since_last_birth}{\code{winik$get_days_since_last_birth()}}
\item \href{#method-add_child}{\code{winik$add_child()}}
\item \href{#method-as_table}{\code{winik$as_table()}}
\item \href{#method-clone}{\code{winik$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Used to created new winik objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{winik$new(
  identifier = NA,
  first_name = NA,
  last_name = NA,
  age = 0,
  mother_id = NA,
  father_id = NA,
  partner = NA,
  children = vector(mode = "character"),
  gender = NA,
  profession = NA,
  alive = TRUE,
  health = 100
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{The winik's identifier}

\item{\code{first_name}}{The winik's first name}

\item{\code{last_name}}{The winik's last naem}

\item{\code{age}}{The age of the winik}

\item{\code{mother_id}}{The identifier of the winik's monther}

\item{\code{father_id}}{The identifier of the winik' father}

\item{\code{partner}}{The identifier of the winik's partner}

\item{\code{children}}{An ordered list of of the children from this winik}

\item{\code{gender}}{The gender of the winik}

\item{\code{profession}}{The winik's profession}

\item{\code{alive}}{Boolean whether the winik is alive or not}

\item{\code{health}}{A percentage value of the winik's current health}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new winik object
A function that returns true or false whether the villager dies
This is run each day
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_alive"></a>}}
\if{latex}{\out{\hypertarget{method-is_alive}{}}}
\subsection{Method \code{is_alive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{winik$is_alive()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A boolean whether the winik is alive (true for yes)
Gets the number of days from the last birth. This is also
the age of the most recently born winik
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_days_since_last_birth"></a>}}
\if{latex}{\out{\hypertarget{method-get_days_since_last_birth}{}}}
\subsection{Method \code{get_days_since_last_birth()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{winik$get_days_since_last_birth()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The number of days since last birth
Connects a child to the winik. This method ensures that the
'children' vector is ordered.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_child"></a>}}
\if{latex}{\out{\hypertarget{method-add_child}{}}}
\subsection{Method \code{add_child()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{winik$add_child(child)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{child}}{The Winik object representing the child}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
Returns a data.frame representation of the winik
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-as_table"></a>}}
\if{latex}{\out{\hypertarget{method-as_table}{}}}
\subsection{Method \code{as_table()}}{
I hope there's a more scalable way to do this in R; Adding every new attribute to this
function isn't practical
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{winik$as_table()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The village_state holds a copy of all of the villagers at each timestep; this method is used to turn
the winik properties into the object inserted in the village_state.
}

\subsection{Returns}{
A data.frame representation of the winik
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{winik$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
