% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimp_se.R
\name{vimp_se}
\alias{vimp_se}
\title{Estimate standard errors}
\usage{
vimp_se(
  est,
  update,
  denom = NULL,
  n = length(update),
  scale = "log",
  na.rm = FALSE
)
}
\arguments{
\item{est}{the estimate of variable importance.}

\item{update}{the influence curve-based update.}

\item{denom}{a list of point estimate and influence curve for the denominator (if any) to make the measure of predictiveness interpretable.}

\item{n}{the sample size.}

\item{scale}{the scale to compute SEs on (either "log", for log-scale, or "identity", for same scale as point estimate).}

\item{na.rm}{logical; should NA's be removed in computation? (defaults to \code{FALSE}).}
}
\value{
The standard error for the estimated variable importance for the given group of left-out covariates.
}
\description{
Compute standard error estimates for estimates of variable importance.
}
\details{
See the paper by Williamson, Gilbert, Simon, and Carone for more
details on the mathematics behind this function and the definition of the parameter of interest.
}
