% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niche-grid-coords.R
\name{niche.grid.coords}
\alias{niche.grid.coords}
\title{Niche Grid Coordinates}
\usage{
niche.grid.coords(mins, maxs, nCoords)
}
\arguments{
\item{mins}{Vector of length \code{n} listing the niche space minimum for each
dimension.}

\item{maxs}{Vector of length \code{n} listing the niche space maximum for each
dimension.}

\item{nCoords}{Number of coordinates across the niche space in all dimensions.}
}
\value{
A matrix with \code{n} columns.
}
\description{
Create an \code{n}-dimensional grid of coordinates across niche space.
}
\details{
This function creates a grid of coordinates systematically located
throughout the specified niche space to enable visualisation of niche patterns.
The extent of the grid is given by the \code{mins} and \code{maxs}, and the number
of coordinates for each dimension is given by \code{nCoords}.
}
\examples{
# Niche space grid coordinates usage
niche.XY = niche.grid.coords(mins=c(15,0), maxs=c(35,200), nCoords=5)
}
\references{
Etherington TR, Omondiagbe OP (2019) virtualNicheR: generating virtual fundamental and realised niches
for use in virtual ecology experiments. Journal of Open Source Software 4:1661 \url{https://doi.org/10.21105/joss.01661}
}
