% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cd_stack.R
\name{cd_stack}
\alias{cd_stack}
\title{CD4 Cell Count or Viral Load Plot of Blending Coefficients for the Stacking Ensemble}
\usage{
cd_stack(outcome, traindata, viralvars, logbase, seed, repetitions, gridsize)
}
\arguments{
\item{outcome}{The outcome variable name (CD4 cell count).}

\item{traindata}{The training data set.}

\item{viralvars}{Vector of viral load variables.}

\item{logbase}{Logarithm base for viral load transformations.}

\item{seed}{Seed for reproducibility.}

\item{repetitions}{Number of repetitions for cross-validation.}

\item{gridsize}{Size of the grid for hyperparameter tuning.}
}
\value{
A plot of a data stack with multiple model definitions and candidate members.
}
\description{
A plot of the contribution of each model obtained using ensemble learning
through stacking of models and grid search for tuning hyperparameters of CD4
cell count or viral load outcomes.
}
\examples{
\donttest{
library(baguette)
library(kernlab)
library(kknn)
library(ranger)
library(rules)
data("cd_train", package = "viruslearner")
outcome <- "cd_2023"
traindata <- cd_train
viralvars <- c("vl_2019", "vl_2021", "vl_2022", "vl_2023")
logbase <- 10
seed <- 1501
repetitions <- 2
gridsize <- 1
cd_stack(outcome, traindata, viralvars, logbase, seed, repetitions, gridsize)
}
}
