% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{viral_new}
\alias{viral_new}
\title{Viral New Dataset}
\format{
A data frame with 87 rows and 21 variables:
\describe{
\item{cd_2018}{CD4 count in 2018.}
\item{cd_2019}{CD4 count in 2019.}
\item{vl_2019}{Viral load in 2019.}
\item{cd_2021}{CD4 count in 2021.}
\item{vl_2021}{Viral load in 2021.}
\item{cd_2022}{CD4 count in 2022.}
\item{vl_2022}{Viral load in 2022.}
\item{cd_2023}{CD4 count in 2023.}
\item{vl_2023}{Viral load in 2023.}
}
}
\usage{
viral_new
}
\description{
The dataset contains information about patients, specifically
their CD4 T cell counts (cd_2018, cd_2019, cd_2021, cd_2022, cd_2023) and
viral loads (vl_2019, vl_2021, vl_2022, vl_2023). For modeling patient
recovery and viral load persistence or suppression, column \code{cd_2023} is
identified as the outcome variable for CD4 cell counts, and column \code{vl_2023}
is identified as the outcome variable for viral load.
}
\examples{
\donttest{
  # Load the dataset
  data("viral_new", package = "viruslearner")
  # Explore the dataset
  library(dplyr)
  dplyr::glimpse(viral_new)
}
}
\keyword{datasets}
