% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtTable.R
\name{gtTable}
\alias{gtTable}
\title{Creates a gt object from a dataframe}
\usage{
gtTable(
  x,
  delim = "\\n",
  style = "default",
  na = "-",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  groupColumn = NULL,
  groupAsColumn = FALSE,
  groupOrder = NULL,
  colsToMergeRows = NULL
)
}
\arguments{
\item{x}{A dataframe.}

\item{delim}{Delimiter.}

\item{style}{Named list that specifies how to style the different parts of
the gt or flextable table generated. Accepted style entries are: title,
subtitle, header, header_name, header_level, column_name, group_label, and
body.
Alternatively, use "default" to get visOmopResults style, or NULL for
gt/flextable style.
Keep in mind that styling code is different for gt and flextable. To see
the "deafult" style code use \code{tableStyle()}.}

\item{na}{How to display missing values.}

\item{title}{Title of the table, or NULL for no title.}

\item{subtitle}{Subtitle of the table, or NULL for no subtitle.}

\item{caption}{Caption for the table, or NULL for no caption. Text in
markdown formatting style (e.g. \verb{*Your caption here*} for caption in
italics).}

\item{groupColumn}{Specifies the columns to use for group labels.
By default, the new group name will be a combination of the column names,
joined by "_". To assign a custom group name, provide a named list such as:
list(\code{newGroupName} = c("variable_name", "variable_level"))}

\item{groupAsColumn}{Whether to display the group labels as a column
(TRUE) or rows (FALSE).}

\item{groupOrder}{Order in which to display group labels.}

\item{colsToMergeRows}{Names of the columns to merge vertically
when consecutive row cells have identical values. Alternatively, use
"all_columns" to apply this merging to all columns, or use NULL to indicate
no merging.}
}
\value{
gt object.

A gt table.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Creates a flextable object from a dataframe using a delimiter to span
the header, and allows to easily customise table style.
}
