% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{barPlot}
\alias{barPlot}
\title{Create a bar plot visualisation from a \verb{<summarised_result>} object}
\usage{
barPlot(
  result,
  x,
  y,
  width = NULL,
  just = 0.5,
  facet = NULL,
  colour = NULL,
  label = character()
)
}
\arguments{
\item{result}{A \verb{<summarised_result>} object.}

\item{x}{Column or estimate name that is used as x variable.}

\item{y}{Column or estimate name that is used as y variable.}

\item{width}{Bar width, as in \code{geom_col()} of the \code{ggplot2} package.}

\item{just}{Adjustment for column placement, as in \code{geom_col()} of the
\code{ggplot2} package.}

\item{facet}{Variables to facet by, a formula can be provided to specify
which variables should be used as rows and which ones as columns.}

\item{colour}{Columns to use to determine the colors.}

\item{label}{Character vector with the columns to display interactively in
\code{plotly}.}
}
\value{
A plot object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
result <- mockSummarisedResult() |> dplyr::filter(variable_name == "age")

barPlot(
  result = result,
  x = "cohort_name",
  y = "mean",
  facet = c("age_group", "sex"),
  colour = "sex")

}
