% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{blaschkeProd}
\alias{blaschkeProd}
\title{Calculate Blaschke products}
\usage{
blaschkeProd(z, a)
}
\arguments{
\item{z}{Complex number; the point in the complex plane to which the output
of the function is mapped}

\item{a}{Vector of complex numbers located inside the unit disk. At each
\code{a}, the Blaschke product will have a zero.}
}
\value{
The value of the Blaschke product at \code{z}.
}
\description{
This function calculates Blaschke products
(\url{https://en.wikipedia.org/wiki/Blaschke_product}) for a complex number
\code{z} given a sequence \code{a} of complex numbers inside the unit disk,
which are the zeroes of the Blaschke product.
}
\details{
A sequence of points \code{a[n]} located inside the unit disk satisfies the
Blaschke condition, if \code{sum[1:n] (1 - abs(a[n])) < Inf}. For each
element \code{a != 0} of such a sequence, \code{B(a, z) = abs(a)/a * (a -
z)/(1 - conj(a) * z)} can be calculated. For \code{a = 0}, \code{B(a, z) =
z}. The Blaschke product \code{B(z)} results as \code{B(z) = prod[1:n]
(B(a[n], z))}.
}
\examples{
# Generate random vector of 17 zeroes inside the unit disk
n <- 17
a <- complex(modulus = runif(n, 0, 1), argument = runif(n, 0, 2*pi))
\donttest{
# Portrait the Blaschke product
phasePortrait(blaschkeProd, moreArgs = list(a = a),
  xlim = c(-1.2, 1.2), ylim = c(-1.2, 1.2),
  nCores = 1) # Max. two cores on CRAN, not a limit for your use
  \dontshow{
  # R CMD check: make sure any open connections are closed afterward
  foreach::registerDoSEQ()
  doParallel::stopImplicitCluster()
  }
}

}
\seealso{
Other maths: 
\code{\link{jacobiTheta}()},
\code{\link{juliaNormal}()},
\code{\link{mandelbrot}()}
}
\concept{maths}
