% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vistime-package.R, R/vistime.R
\docType{package}
\name{vistime}
\alias{vistime}
\alias{vistime-package}
\title{vistime}
\usage{
vistime(data, start = "start", end = "end", groups = "group",
  events = "event", colors = NULL)
}
\arguments{
\item{data}{data for time periods and events (data frame)}

\item{start}{(optional) the column name in \code{data} that contains start dates}

\item{end}{(optional) the column name in \code{data} that contains end dates}

\item{groups}{(optional) the column name in \code{data} to be used for grouping}

\item{events}{(optional) the column name in \code{data} that contains event names}

\item{colors}{(optional) the column name in \code{data} that contains colors for events}
}
\description{
Package to create interactive timelines

Create an interactive timeline using the \code{plotly.js} framework.
There are two types of events: those that define a range (i.e. have a start and end date) and points-in-time (where end date is NA or equal to start date). The data is distributed in a non-overlapping matter and coloured. It can then be edited via \code{plotly_build()} and e.g. be used in Shiny apps
}
\examples{
data(example)
\donttest{vistime(school, events = "Language", groups = "Room")}
}
\author{
Sandro Raabe \email{shosaco_nospam@hotmail.com}
}
\keyword{gantt}
\keyword{plotly}
\keyword{timeline}
\keyword{vistime}

