% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmaps.R
\name{cluster_heatmaps}
\alias{cluster_heatmaps}
\title{Plot heatmap with cluster results and dendrogram}
\usage{
cluster_heatmaps(
  scaled_selected_data,
  clusters,
  k,
  cluster_colors,
  scaled_unselected_data = NULL,
  annotation = NULL
)
}
\arguments{
\item{scaled_selected_data}{scaled matrix or data frame with variables used for clustering}

\item{clusters}{hierarchical cluster results produced by \code{\link[fastcluster:hclust]{fastcluster::hclust()}}}

\item{k}{targeted number of clusters}

\item{cluster_colors}{list of cluster colors to match with boxplots}

\item{scaled_unselected_data}{(optional) scaled matrix or data frame with variables not used for clustering}

\item{annotation}{(optional) \link[ComplexHeatmap:columnAnnotation]{ComplexHeatmap::columnAnnotation} object}
}
\value{
a \link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap}
}
\description{
Plot heatmap with cluster results and dendrogram
}
\examples{
dmat <- compute_dmat(iris, "euclidean", TRUE, c("Petal.Length", "Sepal.Length"))
clusters <- compute_clusters(dmat, "complete")
species_annotation <- create_annotations(iris, "Species")
cluster_heatmaps(scale(iris[c("Petal.Length", "Sepal.Length")]),
                 clusters,
                 3,
                 visxhclust::cluster_colors,
                 annotation = species_annotation)
}
