% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total_fertility_rate.R
\name{total_fertility_rate}
\alias{total_fertility_rate}
\title{Compute total fertility rate from age-specific fertility rates}
\usage{
total_fertility_rate(.data, fertility)
}
\arguments{
\item{.data}{A vital object including an age variable and a variable containing fertility rates.}

\item{fertility}{Variable in \code{.data} containing fertility rates. If omitted, the variable with name  \code{fx}, \code{Fertility} or \code{Rate} will be used (not case sensitive).}
}
\value{
A vital object with total fertility in column \code{tfr}.
}
\description{
Total fertility rate is the expected number of babies per woman in a life-time
given the fertility rate at each age of a woman's life.
}
\examples{
# Compute Australian total fertility rates over time
aus_fertility |>
  total_fertility_rate()
}
\author{
Rob J Hyndman
}
