% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag_em_ratio.R
\name{flag_em_ratio}
\alias{flag_em_ratio}
\title{Flag Persons with unusually high Email Hours to Emails Sent ratio}
\usage{
flag_em_ratio(data, threshold = 1, return = "text")
}
\arguments{
\item{data}{A data frame containing a Person Query.}

\item{threshold}{Numeric value specifying the threshold for flagging.
Defaults to 1.}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"text"}
\item \code{"data"}
}

See \code{Value} for more information.}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"text"}: string. A diagnostic message.
\item \code{"data"}: data frame. Person-level data with those flagged with unusual
ratios.
}
}
\description{
This function flags persons who have an unusual ratio
of email hours to emails sent. If the ratio between Email Hours and
Emails Sent is greater than the threshold, then observations tied to
a \code{PersonId} is flagged as unusual.
}
\examples{
flag_em_ratio(pq_data)

}
\seealso{
Other Data Validation: 
\code{\link{check_query}()},
\code{\link{extract_hr}()},
\code{\link{flag_ch_ratio}()},
\code{\link{flag_extreme}()},
\code{\link{flag_outlooktime}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count_all}()},
\code{\link{hrvar_count}()},
\code{\link{hrvar_trend}()},
\code{\link{identify_churn}()},
\code{\link{identify_holidayweeks}()},
\code{\link{identify_inactiveweeks}()},
\code{\link{identify_nkw}()},
\code{\link{identify_outlier}()},
\code{\link{identify_privacythreshold}()},
\code{\link{identify_shifts}()},
\code{\link{identify_tenure}()},
\code{\link{track_HR_change}()},
\code{\link{validation_report}()}
}
\concept{Data Validation}
