% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_query.R
\name{import_query}
\alias{import_query}
\title{Import a query from Viva Insights Analyst Experience}
\usage{
import_query(
  x,
  pid = NULL,
  dateid = NULL,
  date_format = "\%m/\%d/\%Y",
  convert_date = TRUE,
  encoding = "UTF-8"
)
}
\arguments{
\item{x}{String containing the path to the Viva Insights query to be
imported. The input file must be a .csv file, and the file extension must
be explicitly entered, e.g. \code{"/files/standard query.csv"}}

\item{pid}{String specifying the unique person or individual identifier
variable. \code{import_query} renames this to \code{PersonId} so that this is
compatible with other functions in the package. Defaults to \code{NULL}, where
no action is taken.}

\item{dateid}{String specifying the date variable. \code{import_query} renames
this to \code{MetricDate} so that this is compatible with other functions in the
package. Defaults to \code{NULL}, where no action is taken.}

\item{date_format}{String specifying the date format for converting any
variable that may be a date to a Date variable. Defaults to \code{"\%m/\%d/\%Y"}.}

\item{convert_date}{Logical. Defaults to \code{TRUE}. When set to \code{TRUE}, any
variable that matches true with \code{is_date_format()} gets converted to a Date
variable. When set to \code{FALSE}, this step is skipped.}

\item{encoding}{String to specify encoding to be used within
\code{data.table::fread()}. See \code{data.table::fread()} documentation for more
information. Defaults to \code{'UTF-8'}.}
}
\value{
A \code{tibble} is returned.
}
\description{
Import a Viva Insights Query from a .csv file, with variable
classifications optimised for other functions in the package.
}
\details{
\code{import_query()} uses \code{data.table::fread()} to import .csv files for
speed, and by default \code{stringsAsFactors} is set to FALSE. A data frame is
returned by the function (not a \code{data.table}). Column names are automatically
cleaned, replacing spaces and special characters with underscores.
}
\seealso{
Other Import and Export: 
\code{\link{copy_df}()},
\code{\link{create_dt}()},
\code{\link{export}()}
}
\concept{Import and Export}
