% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viviHeatmap.R
\name{viviHeatmap}
\alias{viviHeatmap}
\title{viviHeatmap}
\usage{
viviHeatmap(
  mat,
  intPal = rev(colorspace::sequential_hcl(palette = "Blues 3", n = 100)),
  impPal = rev(colorspace::sequential_hcl(palette = "Reds 3", n = 100)),
  intLims = NULL,
  impLims = NULL,
  angle = NULL
)
}
\arguments{
\item{mat}{A matrix, such as that returned by vivi, of values to be plotted.}

\item{intPal}{A vector of colours to show interactions, for use with scale_fill_gradientn.}

\item{impPal}{A vector of colours to show importance, for use with scale_fill_gradientn.}

\item{intLims}{Specifies the fit range for the color map for interaction strength.}

\item{impLims}{Specifies the fit range for the color map for importance.}

\item{angle}{The angle to display the x-axis labels.}
}
\value{
A heatmap plot showing variable importance on the diagonal
and variable interaction on the off-diagonal.
}
\description{
Plots a Heatmap showing variable importance on the diagonal
and variable interaction on the off-diagonal.
}
\examples{
\donttest{
library(ranger)
aq <- na.omit(airquality)
rF <- ranger(Ozone ~ ., data = aq, importance = "permutation")
myMat <- vivi(fit = rF, data = aq, response = "Ozone")
viviHeatmap(myMat)
}
}
