% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_sim.R
\name{cusum_arl_h_sim}
\alias{cusum_arl_h_sim}
\title{Compute alarm threshold of the Bernoulli CUSUM control charts using simulation}
\usage{
cusum_arl_h_sim(L0, df, R0 = 1, RA = 2, m = 100, nc = 1,
  verbose = FALSE)
}
\arguments{
\item{L0}{double. Prespecified in-control Average Run Length.}

\item{df}{DataFrame. First column are Parsonnet Score values within a range of zero to 100 representing
the preoperative patient risk. The second column are binary (0/1) outcome values of each operation.}

\item{R0}{double. Odds ratio of death under the null hypotheses.}

\item{RA}{double. Odds ratio of death under the alternative hypotheses. Detecting deterioration
in performance with increased mortality risk by doubling the odds Ratio RA=2. Detecting
improvement in performance with decreased mortality risk by halving the odds ratio of death
RA=1/2.}

\item{m}{integer. Number of simulation runs.}

\item{nc}{integer. Number of cores.}

\item{verbose}{boolean. If TRUE verbose output is included, if FALSE a quiet calculation of h is done.}
}
\value{
Returns a single value which is the control limit h for a given in-control ARL.
}
\description{
Compute alarm threshold of the Bernoulli CUSUM control charts using simulation.
}
\details{
The function \code{cusum_arl_h_sim} determines the control limit for given in-control ARL (L0) by applying a
multi-stage search procedure which includes secant rule and the parallel version of \code{\link{cusum_arl_sim}}
using \code{\link{mclapply}}.
}
\author{
Philipp Wittenberg
}
