% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExampleDatasets.R
\docType{data}
\name{Depression}
\alias{Depression}
\title{Depression data}
\format{
\describe{
   \item{Case}{Number of patients}
   \item{Diagnosis}{Classification based on the initial symptoms of depression ( 1 : Mild, 2 : Severe )}
   \item{Drug}{Drugs given to patients ( 1 : New, 2 : Standard )}
   \item{1week}{Depression symptoms 1week after taking the drug ( 1 : Abnormal, 2 : Normal )}
   \item{2weeks}{Depression symptoms 2weeks after taking the drug ( 1 : Abnormal, 2 : Normal )}
   \item{4weeks}{Depression symptoms 4weeks after taking the drug ( 1 : Abnormal, 2 : Normal )}
}
}
\usage{
data(Depression)
}
\description{
Data comparing two drugs to treat patients suffering from depression.
}
\details{
{
Patients in each group were randomly assigned to standard or new drugs,
and the degree of each patient suffering from depression was classified as
normal or abnormal after 1 week, 2 weeks, and 4 weeks of treatment.\cr
A data frame with 800 rows and 6 variables
\tabular{rccccc}{
\strong{Case}  \tab \strong{Diagnosis}  \tab \strong{Drug} \tab \strong{1week} \tab \strong{2weeks} \tab \strong{4weeks}\cr
1       \tab 1        \tab 2        \tab 2      \tab 2        \tab 2   \cr
2       \tab 1        \tab 2        \tab 2      \tab 2        \tab 2   \cr
3       \tab 1        \tab 2        \tab 2      \tab 2        \tab 2   \cr
4       \tab 1        \tab 2        \tab 2      \tab 2        \tab 2   \cr
5       \tab 1        \tab 2        \tab 2      \tab 2        \tab 2   \cr
6       \tab 1        \tab 2        \tab 2      \tab 2        \tab 2   \cr
7       \tab 1        \tab 2        \tab 2      \tab 2        \tab 2   \cr
8       \tab 1        \tab 2        \tab 2      \tab 2        \tab 2   \cr
9       \tab 1        \tab 2        \tab 2      \tab 2        \tab 2   \cr
10      \tab 1        \tab 2        \tab 2      \tab 2        \tab 2   \cr
\code{.}\tab\code{.}  \tab \code{.} \tab \code{.}\tab\code{.} \tab \code{.}\cr
\code{.}\tab\code{.}  \tab \code{.} \tab \code{.}\tab\code{.} \tab \code{.}\cr
\code{.}\tab\code{.}  \tab \code{.} \tab \code{.}\tab\code{.} \tab \code{.}\cr
796     \tab 2        \tab 1        \tab 1      \tab 1        \tab 1   \cr
797     \tab 2        \tab 1        \tab 1      \tab 1        \tab 1   \cr
798     \tab 2        \tab 1        \tab 1      \tab 1        \tab 1   \cr
799     \tab 2        \tab 1        \tab 1      \tab 1        \tab 1   \cr
800     \tab 2        \tab 1        \tab 1      \tab 1        \tab 1   \cr
 }
}
}
\references{
Koch, G. G., Landis, J. R., Freeman, J. L., Freeman, D. H. and Lehnen, R. C.(1977). A General Methodology for the Analysis of Experiments with Repeated Measurement of Categorical Data. \emph{Biometrics}, \bold{33}, 133-158.
}
\keyword{datasets}
