% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov.R
\name{anonymise}
\alias{anonymise}
\alias{anonymise.vocaldia}
\alias{anonymise.default}
\title{anonymise: anonymise a vocalisation diagram}
\usage{
anonymise(vd)

\method{anonymise}{vocaldia}(vd)

\method{anonymise}{default}(vd)
}
\arguments{
\item{vd}{a vocalisation diagram (vocaldia object)}
}
\value{
a new vocaldia with speaker names replaced by variables
    \eqn{s_1,...,s_n} s.t. \eqn{s_1} is the speaker who spoke the least
    and \eqn{s_n} the one who did the most talking.
}
\description{
Anonymise a vocalisation diagram
}
\details{
"anonymise" a \code{vocaldia} turn taking probability matrix by
replacing speaker names by variables \eqn{s_1,...,s_n$ s.t. $s_1} is
the speaker who spoke the least and \eqn{s_n} the one who did the most
talking.
}
\examples{
\dontrun{
data(vocdia)
x2 <- getSampledVocalMatrix(subset(atddia, id=='Abbott_Maddock_01'),
                            individual=TRUE, nodecolumn='speaker')
anonymise(x2)
}
}
