% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbank.R
\name{makeVocalStatsDataset}
\alias{makeVocalStatsDataset}
\title{makeVocalStatsDataset: create a dataset of vocalisation statistics (1 row per patient)}
\usage{
makeVocalStatsDataset(
  dir = c("data/Pitt/Dementia/cookie", "data/Pitt/Control/cookie"),
  sildir = NULL,
  silsuffix = "c.mp3.csv",
  srdir = "data/Pitt/speech_rate/",
  srsuffix = "sra",
  sprate = T
)
}
\arguments{
\item{dir}{a string or vector containing the location (directory path) of the DementiaBank transcript files (.cha files)}

\item{sildir}{directory where silence csv files are stored}

\item{silsuffix}{the suffix of the silence profile files 'c.mp3.csv'. The format of such files should be the format used by Audacity label files, i.e. 'start time, end time, label' (without header), where 'label' should be 'silence'}

\item{srdir}{directory where speech rate csv (1 value per utterance) files are stored}

\item{srsuffix}{the suffix of the speech rate files (default: sre)}

\item{sprate}{compute speech rate? (not in use yet)}
}
\value{
a session's vocalisation feature stats
}
\description{
Build a data frame createwith vocalisation statistics
}
\examples{
\dontrun{
makeVocalStatsDataset(dir=c('ADReSS-IS2020-data/train/transcription/cc/',
                            'ADReSS-IS2020-data/train/transcription/cd/'),
                     sildir='ADReSS/silence/',
                     srdir='ADReSS/speech_rate/',
                     silsuffix='.wav-sil.csv')
}
}
