evoigt <-
function( data , hyper=NULL, init = NULL , S=10000, burn = S/2, thin=10, fix.arg=NULL, chain=FALSE,...){	
# 
n = length(data)

# check parameters	
if (is.numeric(hyper)){
	if (length(hyper) != 6) stop("length(hyper) should be 6")
	if (any(hyper[2:6] < 0)) stop("scale hyperparameters must be positive")
	mu0 = hyper[1]
	nu20 =hyper[2]
	a0 =hyper[3]
	b0 =hyper[4]
	c0 =hyper[5]
	d0 = hyper[6]
	}	
	if (is.null(hyper)){ 
	0.1 -> mu0 ->nu20 -> a0 ->b0 ->  c0 -> d0
	}
	#names(hyper)=c("mu0", "nu20", "a0", "b0", "c0", "d0")
	
 if  (is.numeric(init)){
 	if (init <= 0) stop("The common starting value must be positive")
 	par.init = init 
	 gamma2<-sigma2<-x0<-par.init 
	    lambda     = rgamma(n, 1/2 , 1/2)
   mu=rnorm(n,par.init,par.init)
   } 
   if (is.character(init)){
     if (init=="rand"){
        gamma2<-rgamma(1,1,1)
        sigma2<-rgamma(1,1,1)
        x0<-1
        lambda     = rgamma(n, 1/2 , 1/2)
        mu=rnorm(n,x0,x0)	
     }
     if (init == "datadriven"){
       sigma2 = gamma2 = var(data[which(data<quantile(data,.75) & data>quantile(data,.25))])/2
      x0  = median(data)
      lambda     = rgamma(n, 1/2 , 1/2)
      mu=rnorm(n,x0,x0)	
     }
     }
	if  (is.null(init)){par.init = 1 
	 gamma2<-sigma2<-x0 <- par.init 
	    lambda     = rgamma(n, 1/2 , 1/2)
        mu=rnorm(n,par.init,par.init)
   }
   sigma2.init<-sigma2
   gamma2.init <- gamma2
   x0.init <- x0
	
	if (burn > S) stop("burn must be less than S")
	
# full conditional
mu.new = function(sigma2, x0,  gamma2, lambda, y){
  post.var = gamma2*sigma2 / (sigma2*lambda+gamma2 )
  post.mean = (sigma2*lambda*y + x0*gamma2) / ( sigma2*lambda + gamma2  )
  rnorm(length(y), post.mean, sqrt(post.var))
}

x0.new = function(mu, sigma2, gamma2, lambda, y){
  post.var = 1 / (1/nu20 + length(y)/sigma2)
  post.mean = ( mu0/nu20+sum(mu)/sigma2) / (1/nu20 + length(y)/sigma2)
  rnorm(1, post.mean, sqrt(post.var))
}

sigma2.new = function(mu, x0, gamma2, lambda, y){
sigma2 = rinvgamma( 1,  shape=(0.5*(length(y) + a0)) , rate=(0.5*(sum((mu-x0)^2)+ b0 )) )
return(sigma2)
}


gamma2.new = function(mu, x0, sigma2, lambda, y){
gamma2 = rinvgamma( 1,  shape=(0.5*(length(y) + c0))  , rate=(0.5*(sum( lambda*(y - mu)^2) + d0 ))	)
return(gamma2)
}

lambda.new = function(mu, x0, sigma2, gamma2, y){
lambda = rgamma( length(y) , shape=1  , rate=(((y - mu )^2 + gamma2)/ ( 2*gamma2)) )
return(lambda)
}
# known parameters?
 if  (is.numeric(fix.arg)){
 	if (length(fix.arg)!=3) stop("Please specify vector (mu, sigma, gamma) by setting NA's or true value(s)")
 	num = which(!is.na(fix.arg))
 	if (length(num)==3) stop("you can specify up to two known parameter values")
 	if (any(num==2) & fix.arg[2] < 0) stop("sigma must be positive")
 	if (any(num==3) & fix.arg[3] < 0) stop("gamma must be positive")
    if( any(num==1)) x0.new <- function(mu, sigma2, gamma2, lambda, y){ fix.arg[1] }
    if( any(num==2)) sigma2.new <- function(mu, x0, gamma2, lambda, y){fix.arg[2]}
    if(any(num==3)) gamma2.new <- function(mu, x0, sigma2, lambda, y){fix.arg[3] }
 	 }

# Gibbs settings
   S = S
   burn = burn
   thin = thin
   st= (S-burn)/thin
   gamma2.samples = rep(0,st)
   sigma2.samples = rep(0,st)
   x0.samples    = rep(0,st)
   mu.samples     = matrix(0,st,n)
   lambda.samples     = matrix(0,st,n)
   
   # Gibbs cycle
        pb <- txtProgressBar(min = 1, max = S, style = 3)
     for(i in 1:S){
     	setTxtProgressBar(pb, i)
   	     mu = mu.new(sigma2, x0,  gamma2, lambda, data)
     x0  = x0.new(mu, sigma2, gamma2, lambda, data)
     sigma2 = sigma2.new(mu, x0, gamma2, lambda, data) 
     gamma2 = gamma2.new(mu, x0, sigma2, lambda, data)
     lambda = lambda.new(mu, x0, sigma2, gamma2, data)
     
     #if(i %% 1000==0) {
       # Print on the screen number of iterations
       #cat(paste0("iteration: ", i, "\n"))
     #}
      # save chain values
          if(i>burn & i %% thin==0){
       sst = (i-burn)/thin
       gamma2.samples[sst] = gamma2
       sigma2.samples[sst] = sigma2
       x0.samples[sst] = x0
       mu.samples[sst,] = mu
       lambda.samples[sst,] = lambda
        }
   }         # end gibbs cycle

# output
gamma.interval = HPDinterval(mcmc(sqrt(gamma2.samples)),...)
# prob = attr(gamma.interval, "Probability")

 sigma.interval = HPDinterval(mcmc(sqrt(sigma2.samples)),...)

 x0.interval = HPDinterval(mcmc(x0.samples),...)

 fwhm.interval=HPDinterval(mcmc(sqrt(sigma2.samples) + sqrt(gamma2.samples)),...)
 
 intervals=list( x0.interval,  sigma.interval ,gamma.interval)

 
 mean.x0 = mean(x0.samples)
 mean.sigma = mean(sqrt(sigma2.samples))
 mean.gamma = mean(sqrt(gamma2.samples))
 mean.fwhm = mean(sqrt(gamma2.samples) + sqrt(sigma2.samples))
 
 means = list( mean.x0, mean.sigma, mean.gamma)
 
 median.x0 = median(x0.samples)
 median.sigma = median(sqrt(sigma2.samples))
 median.gamma = median(sqrt(gamma2.samples))
 median.fwhm = median(sqrt(sigma2.samples) + sqrt(gamma2.samples))
 
 medians = list(median.x0, median.sigma, median.gamma)

  names(intervals) <- names(means) <- names(medians) <- c( "mu", "sigma", "gamma")

results = list(means,medians,intervals)
names(results) = c("posterior mean", "posterior median", "HPD interval")

if (chain) {
	results = c(results, data.frame(mcmc(c(x0.init,x0.samples))), data.frame(mcmc(sqrt(c(sigma2.init,sigma2.samples)) )), data.frame(mcmc(sqrt(c(gamma2.init,gamma2.samples)) )  ))
names(results) = c("posterior mean", "posterior median", "HPD interval","mu.chain","sigma.chain","gamma.chain")
}

return(results)
	
}
