% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_rand_vpoly.R
\name{gen_rand_vpoly}
\alias{gen_rand_vpoly}
\title{Generator function for random V-polytopes}
\usage{
gen_rand_vpoly(dimension, nvertices, generator = NULL, seed = NULL)
}
\arguments{
\item{dimension}{The dimension of the convex polytope.}

\item{nvertices}{The number of the vertices.}

\item{generator}{The body that the generator samples uniformly the vertices from: (a) 'cube' or (b) 'sphere'.}

\item{seed}{Optional. A fixed seed for the generator.}
}
\value{
A polytope class representing a V-polytope.
}
\description{
This function generates a \eqn{d}-dimensional polytope in V-representation with \eqn{m} vertices. We pick \eqn{m} random points from the boundary of the \eqn{d}-dimensional unit hypersphere as vertices.
}
\examples{
# generate a 10-dimensional polytope defined as the convex hull of 25 random vertices
P = gen_rand_vpoly(10, 25)
}
