% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_sdpa_file.R
\name{readSdpaFormatFile}
\alias{readSdpaFormatFile}
\title{Read a SDPA format file}
\usage{
readSdpaFormatFile(path)
}
\arguments{
\item{path}{Name of the input file}
}
\value{
A list with two named items: an item "matrices" which is an object of class Spectrahedron and an vector "objFunction"
}
\description{
Read a SDPA format file and return a spectrahedron (an object of class Spectrahedron) which is defined by
the linear matrix inequality in the input file, and the objective function.
}
\examples{
path = system.file('extdata', package = 'volesti')
l = readSdpaFormatFile(paste0(path,'/sdpa_n2m3.txt'))
Spectrahedron = l$spectrahedron
objFunction = l$objFunction
}
