% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{labs_apply}
\alias{labs_apply}
\title{Set variable labels by setting their comment attributes}
\usage{
labs_apply(data, codes, cols = NULL, values = TRUE)
}
\arguments{
\item{data}{A tibble.}

\item{codes}{A tibble in \link{codebook} format.
To set column labels, use item_name and item_label columns.}

\item{cols}{A tidy column selection. Set to NULL (default) to apply to all columns
found in the codebook.
Restricting the columns is helpful when you  want to set value labels.
In this case, provide a tibble with value_name and value_label columns
and specify the columns that should be modified.}

\item{values}{If TRUE (default), sets value labels.
- For factors: Factor levels and order are retrieved
from the value_label column.
- For item values: they are retrieved from both the columns
value_name and value_label in your codebook.}
}
\value{
A tibble with new labels.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(tibble)
library(volker)

newlabels <- tribble(
  ~item_name,                 ~item_label,
 "cg_adoption_advantage_01", "Allgemeine Vorteile",
 "cg_adoption_advantage_02", "Finanzielle Vorteile",
 "cg_adoption_advantage_03", "Vorteile bei der Arbeit",
 "cg_adoption_advantage_04", "Macht mehr Spaß"
 )

 volker::chatgpt \%>\%
   labs_apply(newlabels) \%>\%
   tab_metrics(starts_with("cg_adoption_advantage_"))
}
