% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{add_clusters}
\alias{add_clusters}
\title{Add cluster number to a data frame}
\usage{
add_clusters(data, cols, newcol = NULL, k = 2, method = "kmeans", clean = TRUE)
}
\arguments{
\item{data}{A dataframe.}

\item{cols}{A tidy selection of item columns.}

\item{newcol}{Name of the new cluster column as a character vector.
Set to NULL (default) to automatically build a name
from the common column prefix, prefixed with "cls_".}

\item{k}{Number of clusters to calculate.
Set to NULL to output a scree plot for up to 10 clusters
and automatically choose the number of clusters based on the elbow criterion.
The within-sums of squares for the scree plot are calculated by
\code{stats::\link[stats:kmeans]{kmeans}}.}

\item{method}{The method as character value. Currently, only kmeans is supported.
All items are scaled before performing the cluster analysis using
\code{base::\link[base:scale]{scale}}.}

\item{clean}{Prepare data by \link{data_clean}.}
}
\value{
The input tibble with additional column
containing cluster values as a factor.
The new column is prefixed with "cls_".
The new column contains the fit result in the attribute stats.kmeans.fit.
The names of the items used for clustering are stored in the attribute stats.kmeans.items.
The clustering diagnostics (Within-Cluster and Between-Cluster Sum of Squares) are stored in the attribute stats.kmeans.wss.
}
\description{
Clustering is performed using \code{stats::\link[stats:kmeans]{kmeans}}.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(volker)
ds <- volker::chatgpt

volker::add_clusters(ds, starts_with("cg_adoption"), k = 3)
}
