% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{players}
\alias{players}
\title{Players data}
\format{Data frame with 1853 rows and 13 columns.
\describe{
  \item{league_gender}{Men or women's league.}
  \item{season_id}{ID for each season unique within league_gender. It consists of the last two digits of the season
  years, e.g., the season_id of season 2014/2015 equals 1415.}
  \item{team_id}{Team identifier which is unique across all teams and seasons.}
  \item{team_name}{Official name of the team. Note that VCO Berlin has a team in men's and women's league.}
  \item{player_id}{Player identifier which is unique within a team in a season. This identifier equals to the
  shirt number of the player. However, in cases where more than one player has the same shirt number, the identifier
  is replaced by a 3-digit number starting at 100.}
  \item{shirt_number}{Official shirt number, not unique within teams (see player_id).}
  \item{position}{Player's specialization}
  \item{firstname}{First name of the player}
  \item{lastname}{Last name of the player}
  \item{gender}{Player's gender: male or female.}
  \item{birthdate}{Date of birth}
  \item{height}{Height in cm}
  \item{nationality}{Nationality of player}
}}
\source{
\url{https://www.volleyball-bundesliga.de/cms/home/1blf/1blf_archiv/1blf_tabellen_ergebnisse.xhtml}
        \url{https://www.volleyball-bundesliga.de/cms/home/1blm/1blm_archiv/1blm_tabellen_ergebnisse.xhtml}
}
\usage{
players
}
\description{
A dataset containing attributes of all players
in the German first division volleyball league for each season
starting in 2013/2014 and ending in 2018/2019.
}
\examples{
players
}
\keyword{datasets}
