% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolateRaster.R
\name{interpolateRaster}
\alias{interpolateRaster}
\title{Interpolate patchily sampled rasters}
\usage{
interpolateRaster(inputRaster, fast = FALSE, ...)
}
\arguments{
\item{inputRaster}{An object of class \code{SpatRaster}}

\item{fast}{A logical operator. Setting to \code{TRUE} triggers use
of \code{fastTps} instead of \code{Tps}.}

\item{...}{For any additional arguments passed to \code{Tps} or \code{fastTps}}
}
\value{
An object of class raster
}
\description{
Uses thin plate spline regression from
\code{fields} package to interpolate missing two-dimensional
raster values.
}
\details{
Missing data values from original raster
are replaced with interpolated values. User has the
option of choosing \code{fastTps} to speed calculation,
but be advised that this is only an approximation
of a true thin plate spline.
}
\examples{
\donttest{
library(terra)
library(fields)
# Create sample raster
r <- rast(ncol=50, nrow=50)
values(r) <- 1:2500

# Introduce a "hole"
values(r)[c(117:127, 167:177, 500:550)] <- NA
plot(r)

# Patch hole with interpolateRaster
interpolatedRaster <- interpolateRaster(r)
plot(interpolatedRaster)
fastInterp <- interpolateRaster(r, fast = TRUE, aRange = 3.0)
plot(fastInterp)
}

}
\seealso{
\code{\link[fields]{Tps}}, \code{\link[fields]{fastTps}}
}
\keyword{dataPrep}
