% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rRec.R
\name{rRec}
\alias{rRec}
\title{Calculate the mean recovery rate (Pacioni et al 2017) and compare
scenarios}
\usage{
rRec(data, project, scenario, ST = FALSE, runs, yr0 = 1, yrt,
  save2disk = TRUE, dir_out = "DataAnalysis/rRec")
}
\arguments{
\item{data}{A data.frame generated by \code{collate_dat}}

\item{project}{The Vortex project name}

\item{scenario}{The ST Vortex scenario name or the scenario that should be
used as baseline if simulations were not conducted with the ST module}

\item{ST}{Whether files are from sensitivity analysis (TRUE),
or not (FALSE, default)}

\item{runs}{The number of Vortex simulation runs}

\item{yr0}{The time window to be considered (first and last year
respectively)}

\item{yrt}{The time window to be considered (first and last year
respectively)}

\item{save2disk}{Whether to save the output to disk, default: TRUE}

\item{dir_out}{The local path to store the output. Default: DataAnalysis/Pairwise}
}
\value{
A table (\code{data.table}) with the mean rRec and its SD, the SSMD
and its associated p-value for each scenario and population
}
\description{
\code{rRec} calculates the mean and standard deviation growth rate between
the time \code{yr0} and \code{yrt}, which was defined as 'recovery rate' by
Pacioni et al (in press). The function then calculates the strictly
standardised mean difference (SSMD, Zhang 2007) for each scenario, and each population
contained in the data. \code{rRec} uses this statistic to compare each scenario
(providing associated p-values) with a baseline scenario.
}
\details{
The means and standard deviations are calculated as:
**check how to insert formula in Roxy tags**
rRec = sigma(Ni*Mi) / sigma(Ni)
(N1*M1+N2*M2+N3*M3)/(N1+N2+N3)
SD ={N1*S1+N2*S2+N3*S3}/(N1+N2+N3)

Where M is the mean growth rate in each year, N is the sample size (number
of simulation runs) and S is the standard deviation.

The baseline scenario is selected with the argument \code{scenario}. However,
if the simulations were part of a sensitivity testing (as indicated by
\code{ST}) then the baseline scenario is selected using the scenario with the
suffix '(Base)'.
}
\examples{
# Using Pacioni et al. example data. See ?pac.clas for more details.
data(pac.clas)
recov <- rRec(pac.clas, project='Pacioni_et_al', scenario='ST_Classic',
              ST=TRUE, runs=3, yr0=1, yrt=120, save2disk=FALSE,
              dir_out='DataAnalysis/rRec')
}
\references{
Zhang, X. D. 2007. A pair of new statistical parameters for quality control
in RNA interference high-throughput screening assays. Genomics 89:552-561.

Pacioni, C., and Mayer, F. (2017). vortexR: an R package for post Vortex
simulation analysis.
}
