% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{generate_beta}
\alias{generate_beta}
\title{Generates a simulation of voting according to a beta law, returns voters preferences}
\usage{
generate_beta(
  n_voters,
  n_candidates,
  beta_a = 0.5,
  beta_b = 0.5,
  lambda = 0,
  min = 0,
  max = 1
)
}
\arguments{
\item{n_voters}{integer, represents the number of voters in the election}

\item{n_candidates}{integer, represents the number of candidates in the election}

\item{beta_a}{double, parameter of the Beta law (by default 0.5)}

\item{beta_b}{double, parameter of the Beta law (by default 0.5)}

\item{lambda}{double, alternative parameter of the Beta law}

\item{min}{int, the minimum value of the range of possible scores (by default 0)}

\item{max}{int, the maximum value of the range of possible scores (by default 1)}
}
\value{
scores
}
\description{
Generates a simulation of voting according to a beta law, returns voters preferences
}
\examples{
voting_situation<- generate_beta(n_voters=10, n_candidates=3, beta_a=1, beta_b=5)

}
