% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list2ballot.R
\name{list2ballot}
\alias{list2ballot}
\title{Repeat ith element of list x for j times to form a larger list}
\usage{
list2ballot(x, n = rep(1, length(x)), string = NULL)
}
\arguments{
\item{x}{a list, each element of which should be a vector.}

\item{n}{how many times each element of x should be replicated.
It should be a numeric vector of non-negative integers and the 
length of it should be equal to that of \code{x}. 
The default is 1 for each element of \code{x}.}

\item{string}{default is NULL. If it is not NULL,  \code{x} 
and \code{n} are ignored. It should be a character vector. Each 
one contains two parts, the 1st is the amount of 
that ballot, and the 2nd part contains the names. The 1st and 
2nd parts, as well as the names, should be split by spaces 
or punctuations. But no space and punctuation is allowed 
inside the names ("_" is not taken to be 
a punctuation). See examples.}
}
\value{
a list with replicated vectors.
}
\description{
Suppose you have 3 different unique ballots and the amount 
of each ballot is 10, 20, 30. Now you want to create raw 
ballots as a list. Then you can use this function. See examples
for usage.
}
\examples{
# Use x and n
unique_ballot <- list(c("A", "B", "C"), c("F", "A", "B"),
		c("E", "D", "C", "B", "F", "A"), c("x","x", "A")
)
r <- c(1, 2, 3, 0)
y <- list2ballot(unique_ballot, r)

# Use string, x and n will be ignored.
# The characters can be written in a very loose way as follows, 
# for the function will automatically delete unwanted parts.
# But do make sure there is no space or punctuation
# inside the names.
unique_ballot <- c(
	"2, Bob, Mike Jane", 	"3: barack_obama;;Bob>Jane", 
	"0 Smith   Jane", "  1 Mike???!!!"
)
y <- list2ballot(string = unique_ballot)
}
