% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_tableau_crosstab_excel.R
\name{download_tableau_crosstab_excel}
\alias{download_tableau_crosstab_excel}
\title{Download Tableau view crosstab as Excel}
\usage{
download_tableau_crosstab_excel(
  tableau,
  view_id,
  path_to_save,
  api_version = 3.16
)
}
\arguments{
\item{tableau}{A list containing the Tableau authentication variables: `base_url`, `token`, `user_id`, and `site_id`.}

\item{view_id}{The ID of the view to download.}

\item{path_to_save}{The directory to write the crosstab Excel file to.}

\item{api_version}{The API version to use (default: 3.16).}
}
\description{
Downloads the crosstab data from a Tableau view in Excel format.
}
\seealso{
Other Tableau REST API: 
\code{\link{authenticate_server}()},
\code{\link{download_filtered_tableau_image}()},
\code{\link{download_tableau_data}()},
\code{\link{download_workbooks_server_pdf}()},
\code{\link{download_workbooks_server_powerpoint}()},
\code{\link{download_workbooks_server}()},
\code{\link{get_server_connected_apps}()},
\code{\link{get_server_datasources}()},
\code{\link{get_server_groups}()},
\code{\link{get_server_info}()},
\code{\link{get_server_jobs}()},
\code{\link{get_server_projects}()},
\code{\link{get_server_refresh_tasks}()},
\code{\link{get_server_schedules}()},
\code{\link{get_server_user_favorites}()},
\code{\link{get_server_users}()},
\code{\link{get_server_views}()},
\code{\link{get_server_workbooks}()}
}
\concept{Tableau REST API}
