
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_rw_model_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
gaussian_filter_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
                         const Eigen::Matrix<T1__, Eigen::Dynamic,1>& a1,
                         const Eigen::Matrix<T2__, Eigen::Dynamic,1>& P1,
                         const T3__& Ht,
                         const Eigen::Matrix<T4__, Eigen::Dynamic,Eigen::Dynamic>& Rt,
                         const Eigen::Matrix<T5__, Eigen::Dynamic,Eigen::Dynamic>& xreg, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int n(0);
            (void) n;  // dummy to suppress unused var warning

            stan::math::fill(n, std::numeric_limits<int>::min());
            stan::math::assign(n,rows(y));
            int m(0);
            (void) m;  // dummy to suppress unused var warning

            stan::math::fill(m, std::numeric_limits<int>::min());
            stan::math::assign(m,rows(a1));
            fun_scalar_t__ loglik;
            (void) loglik;  // dummy to suppress unused var warning

            stan::math::initialize(loglik, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(loglik,DUMMY_VAR__);
            stan::math::assign(loglik,0.0);
            validate_non_negative_index("x", "m", m);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  x(static_cast<Eigen::VectorXd::Index>(m));
            (void) x;  // dummy to suppress unused var warning

            stan::math::initialize(x, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(x,DUMMY_VAR__);
            stan::math::assign(x,a1);
            validate_non_negative_index("P", "m", m);
            validate_non_negative_index("P", "m", m);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  P(static_cast<Eigen::VectorXd::Index>(m),static_cast<Eigen::VectorXd::Index>(m));
            (void) P;  // dummy to suppress unused var warning

            stan::math::initialize(P, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(P,DUMMY_VAR__);
            stan::math::assign(P,diag_matrix(P1));


            for (int t = 1; t <= n; ++t) {
                {
                    fun_scalar_t__ F;
                    (void) F;  // dummy to suppress unused var warning

                    stan::math::initialize(F, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(F,DUMMY_VAR__);
                    stan::math::assign(F,(quad_form(P,stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + Ht));
                    fun_scalar_t__ v;
                    (void) v;  // dummy to suppress unused var warning

                    stan::math::initialize(v, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(v,DUMMY_VAR__);
                    stan::math::assign(v,(get_base1(y,t,"y",1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"),x)));
                    validate_non_negative_index("K", "m", m);
                    Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  K(static_cast<Eigen::VectorXd::Index>(m));
                    (void) K;  // dummy to suppress unused var warning

                    stan::math::initialize(K, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(K,DUMMY_VAR__);
                    stan::math::assign(K,divide(multiply(P,stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")),F));


                    stan::math::assign(x, add(x,multiply(K,v)));
                    stan::math::assign(P, add(subtract(P,multiply(multiply(K,transpose(K)),F)),Rt));
                    stan::math::assign(loglik, (loglik - (0.5 * (log(F) + ((v * v) / F)))));
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(loglik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
gaussian_filter_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
                         const Eigen::Matrix<T1__, Eigen::Dynamic,1>& a1,
                         const Eigen::Matrix<T2__, Eigen::Dynamic,1>& P1,
                         const T3__& Ht,
                         const Eigen::Matrix<T4__, Eigen::Dynamic,Eigen::Dynamic>& Rt,
                         const Eigen::Matrix<T5__, Eigen::Dynamic,Eigen::Dynamic>& xreg, std::ostream* pstream__) {
    return gaussian_filter_lpdf<false>(y,a1,P1,Ht,Rt,xreg, pstream__);
}


struct gaussian_filter_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
                         const Eigen::Matrix<T1__, Eigen::Dynamic,1>& a1,
                         const Eigen::Matrix<T2__, Eigen::Dynamic,1>& P1,
                         const T3__& Ht,
                         const Eigen::Matrix<T4__, Eigen::Dynamic,Eigen::Dynamic>& Rt,
                         const Eigen::Matrix<T5__, Eigen::Dynamic,Eigen::Dynamic>& xreg, std::ostream* pstream__) const {
        return gaussian_filter_lpdf(y, a1, P1, Ht, Rt, xreg, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type, Eigen::Dynamic,Eigen::Dynamic>
gaussian_smoother(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
                      const Eigen::Matrix<T1__, Eigen::Dynamic,1>& a1,
                      const Eigen::Matrix<T2__, Eigen::Dynamic,1>& P1,
                      const T3__& Ht,
                      const Eigen::Matrix<T4__, Eigen::Dynamic,Eigen::Dynamic>& Rt,
                      const Eigen::Matrix<T5__, Eigen::Dynamic,Eigen::Dynamic>& xreg, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            int n(0);
            (void) n;  // dummy to suppress unused var warning

            stan::math::fill(n, std::numeric_limits<int>::min());
            stan::math::assign(n,rows(y));
            int m(0);
            (void) m;  // dummy to suppress unused var warning

            stan::math::fill(m, std::numeric_limits<int>::min());
            stan::math::assign(m,rows(a1));
            validate_non_negative_index("x", "m", m);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  x(static_cast<Eigen::VectorXd::Index>(m));
            (void) x;  // dummy to suppress unused var warning

            stan::math::initialize(x, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(x,DUMMY_VAR__);
            stan::math::assign(x,a1);
            validate_non_negative_index("P", "m", m);
            validate_non_negative_index("P", "m", m);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  P(static_cast<Eigen::VectorXd::Index>(m),static_cast<Eigen::VectorXd::Index>(m));
            (void) P;  // dummy to suppress unused var warning

            stan::math::initialize(P, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(P,DUMMY_VAR__);
            stan::math::assign(P,diag_matrix(P1));
            validate_non_negative_index("v", "n", n);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  v(static_cast<Eigen::VectorXd::Index>(n));
            (void) v;  // dummy to suppress unused var warning

            stan::math::initialize(v, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(v,DUMMY_VAR__);
            validate_non_negative_index("F", "n", n);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  F(static_cast<Eigen::VectorXd::Index>(n));
            (void) F;  // dummy to suppress unused var warning

            stan::math::initialize(F, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(F,DUMMY_VAR__);
            validate_non_negative_index("K", "m", m);
            validate_non_negative_index("K", "n", n);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  K(static_cast<Eigen::VectorXd::Index>(m),static_cast<Eigen::VectorXd::Index>(n));
            (void) K;  // dummy to suppress unused var warning

            stan::math::initialize(K, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(K,DUMMY_VAR__);
            validate_non_negative_index("r", "m", m);
            validate_non_negative_index("r", "(n + 1)", (n + 1));
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  r(static_cast<Eigen::VectorXd::Index>(m),static_cast<Eigen::VectorXd::Index>((n + 1)));
            (void) r;  // dummy to suppress unused var warning

            stan::math::initialize(r, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(r,DUMMY_VAR__);
            validate_non_negative_index("tmpr", "m", m);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  tmpr(static_cast<Eigen::VectorXd::Index>(m));
            (void) tmpr;  // dummy to suppress unused var warning

            stan::math::initialize(tmpr, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(tmpr,DUMMY_VAR__);


            for (int t = 1; t <= n; ++t) {

                stan::math::assign(get_base1_lhs(F,t,"F",1), (quad_form(P,stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + Ht));
                stan::math::assign(get_base1_lhs(v,t,"v",1), (get_base1(y,t,"y",1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"),x)));
                stan::model::assign(K, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            divide(multiply(P,stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")),get_base1(F,t,"F",1)), 
                            "assigning variable K");
                stan::math::assign(x, add(x,multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"),get_base1(v,t,"v",1))));
                stan::math::assign(P, add(subtract(P,multiply(multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"),transpose(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"))),get_base1(F,t,"F",1))),Rt));
            }
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((n + 1)), stan::model::nil_index_list())), 
                        rep_vector(0.0,m), 
                        "assigning variable r");
            for (int tt = 1; tt <= n; ++tt) {
                {
                    int t(0);
                    (void) t;  // dummy to suppress unused var warning

                    stan::math::fill(t, std::numeric_limits<int>::min());
                    stan::math::assign(t,((n + 1) - tt));
                    validate_non_negative_index("tmp", "m", m);
                    Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  tmp(static_cast<Eigen::VectorXd::Index>(m));
                    (void) tmp;  // dummy to suppress unused var warning

                    stan::math::initialize(tmp, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(tmp,DUMMY_VAR__);
                    stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), "r"));


                    if (as_bool(logical_gt(get_base1(F,t,"F",1),1e-08))) {

                        stan::model::assign(r, 
                                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                    subtract(add(divide(multiply(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"),get_base1(v,t,"v",1)),get_base1(F,t,"F",1)),tmp),multiply(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"),dot_product(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"),tmp))), 
                                    "assigning variable r");
                    }
                }
            }
            stan::math::assign(tmpr, stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "r"));
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        add(a1,elt_multiply(P1,tmpr)), 
                        "assigning variable r");
            for (int t = 2; t <= n; ++t) {
                {
                    validate_non_negative_index("tmp", "m", m);
                    Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  tmp(static_cast<Eigen::VectorXd::Index>(m));
                    (void) tmp;  // dummy to suppress unused var warning

                    stan::math::initialize(tmp, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(tmp,DUMMY_VAR__);
                    stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "r"));
                    validate_non_negative_index("tmp2", "m", m);
                    Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  tmp2(static_cast<Eigen::VectorXd::Index>(m));
                    (void) tmp2;  // dummy to suppress unused var warning

                    stan::math::initialize(tmp2, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(tmp2,DUMMY_VAR__);
                    stan::math::assign(tmp2,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r"));


                    stan::model::assign(r, 
                                stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                add(tmp,multiply(Rt,tmp2)), 
                                "assigning variable r");
                }
            }
            return stan::math::promote_scalar<fun_return_scalar_t__>(stan::model::rvalue(r, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::nil_index_list())), "r"));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct gaussian_smoother_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type, Eigen::Dynamic,Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& y,
                      const Eigen::Matrix<T1__, Eigen::Dynamic,1>& a1,
                      const Eigen::Matrix<T2__, Eigen::Dynamic,1>& P1,
                      const T3__& Ht,
                      const Eigen::Matrix<T4__, Eigen::Dynamic,Eigen::Dynamic>& Rt,
                      const Eigen::Matrix<T5__, Eigen::Dynamic,Eigen::Dynamic>& xreg, std::ostream* pstream__) const {
        return gaussian_smoother(y, a1, P1, Ht, Rt, xreg, pstream__);
    }
};

class model_rw_model : public prob_grad {
private:
    int k;
    int n;
    matrix_d xreg;
    vector_d y;
    vector_d beta_mean;
    vector_d beta_sd;
    vector_d sigma_mean;
    vector_d sigma_sd;
    int n_new;
    matrix_d xreg_new;
    vector_d sigma_b_mean;
    vector_d sigma_b_sd;
    double sigma_y_mean;
    double sigma_y_sd;
public:
    model_rw_model(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_rw_model(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_rw_model_namespace::model_rw_model";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "k", "int", context__.to_vec());
        k = int(0);
        vals_i__ = context__.vals_i("k");
        pos__ = 0;
        k = vals_i__[pos__++];
        context__.validate_dims("data initialization", "n", "int", context__.to_vec());
        n = int(0);
        vals_i__ = context__.vals_i("n");
        pos__ = 0;
        n = vals_i__[pos__++];
        validate_non_negative_index("xreg", "k", k);
        validate_non_negative_index("xreg", "n", n);
        context__.validate_dims("data initialization", "xreg", "matrix_d", context__.to_vec(k,n));
        validate_non_negative_index("xreg", "k", k);
        validate_non_negative_index("xreg", "n", n);
        xreg = matrix_d(static_cast<Eigen::VectorXd::Index>(k),static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("xreg");
        pos__ = 0;
        size_t xreg_m_mat_lim__ = k;
        size_t xreg_n_mat_lim__ = n;
        for (size_t n_mat__ = 0; n_mat__ < xreg_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < xreg_m_mat_lim__; ++m_mat__) {
                xreg(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("y", "n", n);
        context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(n));
        validate_non_negative_index("y", "n", n);
        y = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("y");
        pos__ = 0;
        size_t y_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < y_i_vec_lim__; ++i_vec__) {
            y[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("beta_mean", "k", k);
        context__.validate_dims("data initialization", "beta_mean", "vector_d", context__.to_vec(k));
        validate_non_negative_index("beta_mean", "k", k);
        beta_mean = vector_d(static_cast<Eigen::VectorXd::Index>(k));
        vals_r__ = context__.vals_r("beta_mean");
        pos__ = 0;
        size_t beta_mean_i_vec_lim__ = k;
        for (size_t i_vec__ = 0; i_vec__ < beta_mean_i_vec_lim__; ++i_vec__) {
            beta_mean[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("beta_sd", "k", k);
        context__.validate_dims("data initialization", "beta_sd", "vector_d", context__.to_vec(k));
        validate_non_negative_index("beta_sd", "k", k);
        beta_sd = vector_d(static_cast<Eigen::VectorXd::Index>(k));
        vals_r__ = context__.vals_r("beta_sd");
        pos__ = 0;
        size_t beta_sd_i_vec_lim__ = k;
        for (size_t i_vec__ = 0; i_vec__ < beta_sd_i_vec_lim__; ++i_vec__) {
            beta_sd[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("sigma_mean", "(k + 1)", (k + 1));
        context__.validate_dims("data initialization", "sigma_mean", "vector_d", context__.to_vec((k + 1)));
        validate_non_negative_index("sigma_mean", "(k + 1)", (k + 1));
        sigma_mean = vector_d(static_cast<Eigen::VectorXd::Index>((k + 1)));
        vals_r__ = context__.vals_r("sigma_mean");
        pos__ = 0;
        size_t sigma_mean_i_vec_lim__ = (k + 1);
        for (size_t i_vec__ = 0; i_vec__ < sigma_mean_i_vec_lim__; ++i_vec__) {
            sigma_mean[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("sigma_sd", "(k + 1)", (k + 1));
        context__.validate_dims("data initialization", "sigma_sd", "vector_d", context__.to_vec((k + 1)));
        validate_non_negative_index("sigma_sd", "(k + 1)", (k + 1));
        sigma_sd = vector_d(static_cast<Eigen::VectorXd::Index>((k + 1)));
        vals_r__ = context__.vals_r("sigma_sd");
        pos__ = 0;
        size_t sigma_sd_i_vec_lim__ = (k + 1);
        for (size_t i_vec__ = 0; i_vec__ < sigma_sd_i_vec_lim__; ++i_vec__) {
            sigma_sd[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "n_new", "int", context__.to_vec());
        n_new = int(0);
        vals_i__ = context__.vals_i("n_new");
        pos__ = 0;
        n_new = vals_i__[pos__++];
        validate_non_negative_index("xreg_new", "k", k);
        validate_non_negative_index("xreg_new", "n_new", n_new);
        context__.validate_dims("data initialization", "xreg_new", "matrix_d", context__.to_vec(k,n_new));
        validate_non_negative_index("xreg_new", "k", k);
        validate_non_negative_index("xreg_new", "n_new", n_new);
        xreg_new = matrix_d(static_cast<Eigen::VectorXd::Index>(k),static_cast<Eigen::VectorXd::Index>(n_new));
        vals_r__ = context__.vals_r("xreg_new");
        pos__ = 0;
        size_t xreg_new_m_mat_lim__ = k;
        size_t xreg_new_n_mat_lim__ = n_new;
        for (size_t n_mat__ = 0; n_mat__ < xreg_new_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < xreg_new_m_mat_lim__; ++m_mat__) {
                xreg_new(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"k",k,0);
        check_greater_or_equal(function__,"n",n,0);
        check_greater_or_equal(function__,"n_new",n_new,0);
        // initialize data variables
        validate_non_negative_index("sigma_b_mean", "k", k);
        sigma_b_mean = vector_d(static_cast<Eigen::VectorXd::Index>(k));
        stan::math::fill(sigma_b_mean,DUMMY_VAR__);
        stan::math::assign(sigma_b_mean,stan::model::rvalue(sigma_mean, stan::model::cons_list(stan::model::index_min(2), stan::model::nil_index_list()), "sigma_mean"));
        validate_non_negative_index("sigma_b_sd", "k", k);
        sigma_b_sd = vector_d(static_cast<Eigen::VectorXd::Index>(k));
        stan::math::fill(sigma_b_sd,DUMMY_VAR__);
        stan::math::assign(sigma_b_sd,stan::model::rvalue(sigma_sd, stan::model::cons_list(stan::model::index_min(2), stan::model::nil_index_list()), "sigma_sd"));
        sigma_y_mean = double(0);
        stan::math::fill(sigma_y_mean,DUMMY_VAR__);
        stan::math::assign(sigma_y_mean,get_base1(sigma_mean,1,"sigma_mean",1));
        sigma_y_sd = double(0);
        stan::math::fill(sigma_y_sd,DUMMY_VAR__);
        stan::math::assign(sigma_y_sd,get_base1(sigma_sd,1,"sigma_sd",1));

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("sigma_b", "k", k);
        num_params_r__ += k;
        ++num_params_r__;
    }

    ~model_rw_model() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("sigma_b")))
            throw std::runtime_error("variable sigma_b missing");
        vals_r__ = context__.vals_r("sigma_b");
        pos__ = 0U;
        validate_non_negative_index("sigma_b", "k", k);
        context__.validate_dims("initialization", "sigma_b", "double", context__.to_vec(k));
        // generate_declaration sigma_b
        std::vector<double> sigma_b(k,double(0));
        for (int i0__ = 0U; i0__ < k; ++i0__)
            sigma_b[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < k; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,sigma_b[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_b: ") + e.what());
        }

        if (!(context__.contains_r("sigma_y")))
            throw std::runtime_error("variable sigma_y missing");
        vals_r__ = context__.vals_r("sigma_y");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_y", "double", context__.to_vec());
        // generate_declaration sigma_y
        double sigma_y(0);
        sigma_y = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_y);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_y: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        vector<T__> sigma_b;
        size_t dim_sigma_b_0__ = k;
        sigma_b.reserve(dim_sigma_b_0__);
        for (size_t k_0__ = 0; k_0__ < dim_sigma_b_0__; ++k_0__) {
            if (jacobian__)
                sigma_b.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                sigma_b.push_back(in__.scalar_lb_constrain(0));
        }

        T__ sigma_y;
        (void) sigma_y;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_y = in__.scalar_lb_constrain(0,lp__);
        else
            sigma_y = in__.scalar_lb_constrain(0);


        // transformed parameters
        validate_non_negative_index("R_vector", "k", k);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  R_vector(static_cast<Eigen::VectorXd::Index>(k));
        (void) R_vector;  // dummy to suppress unused var warning

        stan::math::initialize(R_vector, DUMMY_VAR__);
        stan::math::fill(R_vector,DUMMY_VAR__);
        validate_non_negative_index("P1_vector", "k", k);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  P1_vector(static_cast<Eigen::VectorXd::Index>(k));
        (void) P1_vector;  // dummy to suppress unused var warning

        stan::math::initialize(P1_vector, DUMMY_VAR__);
        stan::math::fill(P1_vector,DUMMY_VAR__);


        try {
            for (int i = 1; i <= k; ++i) {

                stan::math::assign(get_base1_lhs(R_vector,i,"R_vector",1), pow(get_base1(sigma_b,i,"sigma_b",1),2));
                stan::math::assign(get_base1_lhs(P1_vector,i,"P1_vector",1), pow(get_base1(beta_sd,i,"beta_sd",1),2));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < k; ++i0__) {
            if (stan::math::is_uninitialized(R_vector(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: R_vector" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < k; ++i0__) {
            if (stan::math::is_uninitialized(P1_vector(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: P1_vector" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(sigma_b, sigma_b_mean, sigma_b_sd));
            lp_accum__.add(normal_log<propto__>(sigma_y, sigma_y_mean, sigma_y_sd));
            lp_accum__.add(gaussian_filter_lpdf<propto__>(y, beta_mean, P1_vector, pow(sigma_y,2), diag_matrix(R_vector), xreg, pstream__));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("sigma_b");
        names__.push_back("sigma_y");
        names__.push_back("R_vector");
        names__.push_back("P1_vector");
        names__.push_back("y_rep");
        names__.push_back("beta");
        names__.push_back("y_new");
        names__.push_back("beta_new");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_new);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_rw_model_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector<double> sigma_b;
        size_t dim_sigma_b_0__ = k;
        for (size_t k_0__ = 0; k_0__ < dim_sigma_b_0__; ++k_0__) {
            sigma_b.push_back(in__.scalar_lb_constrain(0));
        }
        double sigma_y = in__.scalar_lb_constrain(0);
        for (int k_0__ = 0; k_0__ < k; ++k_0__) {
            vars__.push_back(sigma_b[k_0__]);
        }
        vars__.push_back(sigma_y);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("R_vector", "k", k);
        vector_d R_vector(static_cast<Eigen::VectorXd::Index>(k));
        (void) R_vector;  // dummy to suppress unused var warning

        stan::math::initialize(R_vector, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(R_vector,DUMMY_VAR__);
        validate_non_negative_index("P1_vector", "k", k);
        vector_d P1_vector(static_cast<Eigen::VectorXd::Index>(k));
        (void) P1_vector;  // dummy to suppress unused var warning

        stan::math::initialize(P1_vector, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(P1_vector,DUMMY_VAR__);


        try {
            for (int i = 1; i <= k; ++i) {

                stan::math::assign(get_base1_lhs(R_vector,i,"R_vector",1), pow(get_base1(sigma_b,i,"sigma_b",1),2));
                stan::math::assign(get_base1_lhs(P1_vector,i,"P1_vector",1), pow(get_base1(beta_sd,i,"beta_sd",1),2));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < k; ++k_0__) {
            vars__.push_back(R_vector[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < k; ++k_0__) {
            vars__.push_back(P1_vector[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("y_rep", "n", n);
        vector_d y_rep(static_cast<Eigen::VectorXd::Index>(n));
        (void) y_rep;  // dummy to suppress unused var warning

        stan::math::initialize(y_rep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(y_rep,DUMMY_VAR__);
        validate_non_negative_index("beta", "k", k);
        validate_non_negative_index("beta", "n", n);
        matrix_d beta(static_cast<Eigen::VectorXd::Index>(k),static_cast<Eigen::VectorXd::Index>(n));
        (void) beta;  // dummy to suppress unused var warning

        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);
        validate_non_negative_index("y_new", "n_new", n_new);
        vector_d y_new(static_cast<Eigen::VectorXd::Index>(n_new));
        (void) y_new;  // dummy to suppress unused var warning

        stan::math::initialize(y_new, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(y_new,DUMMY_VAR__);
        validate_non_negative_index("beta_new", "k", k);
        vector_d beta_new(static_cast<Eigen::VectorXd::Index>(k));
        (void) beta_new;  // dummy to suppress unused var warning

        stan::math::initialize(beta_new, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta_new,DUMMY_VAR__);


        try {
            for (int i = 1; i <= k; ++i) {

                stan::math::assign(get_base1_lhs(beta,i,1,"beta",1), normal_rng(get_base1(beta_mean,i,"beta_mean",1),get_base1(beta_sd,i,"beta_sd",1), base_rng__));
            }
            for (int t = 1; t <= (n - 1); ++t) {

                for (int i = 1; i <= k; ++i) {

                    stan::math::assign(get_base1_lhs(beta,i,(t + 1),"beta",1), normal_rng(get_base1(beta,i,t,"beta",1),get_base1(sigma_b,i,"sigma_b",1), base_rng__));
                }
            }
            for (int t = 1; t <= n; ++t) {

                stan::math::assign(get_base1_lhs(y_rep,t,"y_rep",1), normal_rng(dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"),stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta")),sigma_y, base_rng__));
            }
            stan::math::assign(beta, add(beta,gaussian_smoother(subtract(y,y_rep),beta_mean,P1_vector,pow(sigma_y,2),diag_matrix(R_vector),xreg, pstream__)));
            for (int t = 1; t <= n; ++t) {

                stan::math::assign(get_base1_lhs(y_rep,t,"y_rep",1), (dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"),stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta")) + normal_rng(0,sigma_y, base_rng__)));
            }
            if (as_bool(logical_gt(n_new,0))) {

                for (int i = 1; i <= k; ++i) {

                    stan::math::assign(get_base1_lhs(beta_new,i,"beta_new",1), normal_rng(get_base1(beta,i,n,"beta",1),get_base1(sigma_b,i,"sigma_b",1), base_rng__));
                }
                for (int t = 1; t <= n_new; ++t) {

                    stan::math::assign(get_base1_lhs(y_new,t,"y_new",1), (dot_product(stan::model::rvalue(xreg_new, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg_new"),beta_new) + normal_rng(0,sigma_y, base_rng__)));
                    for (int i = 1; i <= k; ++i) {

                        stan::math::assign(get_base1_lhs(beta_new,i,"beta_new",1), normal_rng(get_base1(beta_new,i,"beta_new",1),get_base1(sigma_b,i,"sigma_b",1), base_rng__));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(y_rep[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < n; ++k_1__) {
            for (int k_0__ = 0; k_0__ < k; ++k_0__) {
                vars__.push_back(beta(k_0__, k_1__));
            }
        }
        for (int k_0__ = 0; k_0__ < n_new; ++k_0__) {
            vars__.push_back(y_new[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < k; ++k_0__) {
            vars__.push_back(beta_new[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_rw_model";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "R_vector" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "P1_vector" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_rep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= n; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= n_new; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_new" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_new" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "R_vector" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "P1_vector" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_rep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= n; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= n_new; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_new" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_new" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_rw_model_naive_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_rw_model_naive : public prob_grad {
private:
    int k;
    int n;
    matrix_d xreg;
    vector_d y;
    vector_d beta_mean;
    vector_d beta_sd;
    vector_d sigma_mean;
    vector_d sigma_sd;
    vector_d sigma_b_mean;
    vector_d sigma_b_sd;
    double sigma_y_mean;
    double sigma_y_sd;
public:
    model_rw_model_naive(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_rw_model_naive(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_rw_model_naive_namespace::model_rw_model_naive";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "k", "int", context__.to_vec());
        k = int(0);
        vals_i__ = context__.vals_i("k");
        pos__ = 0;
        k = vals_i__[pos__++];
        context__.validate_dims("data initialization", "n", "int", context__.to_vec());
        n = int(0);
        vals_i__ = context__.vals_i("n");
        pos__ = 0;
        n = vals_i__[pos__++];
        validate_non_negative_index("xreg", "k", k);
        validate_non_negative_index("xreg", "n", n);
        context__.validate_dims("data initialization", "xreg", "matrix_d", context__.to_vec(k,n));
        validate_non_negative_index("xreg", "k", k);
        validate_non_negative_index("xreg", "n", n);
        xreg = matrix_d(static_cast<Eigen::VectorXd::Index>(k),static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("xreg");
        pos__ = 0;
        size_t xreg_m_mat_lim__ = k;
        size_t xreg_n_mat_lim__ = n;
        for (size_t n_mat__ = 0; n_mat__ < xreg_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < xreg_m_mat_lim__; ++m_mat__) {
                xreg(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("y", "n", n);
        context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(n));
        validate_non_negative_index("y", "n", n);
        y = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("y");
        pos__ = 0;
        size_t y_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < y_i_vec_lim__; ++i_vec__) {
            y[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("beta_mean", "k", k);
        context__.validate_dims("data initialization", "beta_mean", "vector_d", context__.to_vec(k));
        validate_non_negative_index("beta_mean", "k", k);
        beta_mean = vector_d(static_cast<Eigen::VectorXd::Index>(k));
        vals_r__ = context__.vals_r("beta_mean");
        pos__ = 0;
        size_t beta_mean_i_vec_lim__ = k;
        for (size_t i_vec__ = 0; i_vec__ < beta_mean_i_vec_lim__; ++i_vec__) {
            beta_mean[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("beta_sd", "k", k);
        context__.validate_dims("data initialization", "beta_sd", "vector_d", context__.to_vec(k));
        validate_non_negative_index("beta_sd", "k", k);
        beta_sd = vector_d(static_cast<Eigen::VectorXd::Index>(k));
        vals_r__ = context__.vals_r("beta_sd");
        pos__ = 0;
        size_t beta_sd_i_vec_lim__ = k;
        for (size_t i_vec__ = 0; i_vec__ < beta_sd_i_vec_lim__; ++i_vec__) {
            beta_sd[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("sigma_mean", "(k + 1)", (k + 1));
        context__.validate_dims("data initialization", "sigma_mean", "vector_d", context__.to_vec((k + 1)));
        validate_non_negative_index("sigma_mean", "(k + 1)", (k + 1));
        sigma_mean = vector_d(static_cast<Eigen::VectorXd::Index>((k + 1)));
        vals_r__ = context__.vals_r("sigma_mean");
        pos__ = 0;
        size_t sigma_mean_i_vec_lim__ = (k + 1);
        for (size_t i_vec__ = 0; i_vec__ < sigma_mean_i_vec_lim__; ++i_vec__) {
            sigma_mean[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("sigma_sd", "(k + 1)", (k + 1));
        context__.validate_dims("data initialization", "sigma_sd", "vector_d", context__.to_vec((k + 1)));
        validate_non_negative_index("sigma_sd", "(k + 1)", (k + 1));
        sigma_sd = vector_d(static_cast<Eigen::VectorXd::Index>((k + 1)));
        vals_r__ = context__.vals_r("sigma_sd");
        pos__ = 0;
        size_t sigma_sd_i_vec_lim__ = (k + 1);
        for (size_t i_vec__ = 0; i_vec__ < sigma_sd_i_vec_lim__; ++i_vec__) {
            sigma_sd[i_vec__] = vals_r__[pos__++];
        }

        // validate, data variables
        check_greater_or_equal(function__,"k",k,0);
        check_greater_or_equal(function__,"n",n,0);
        // initialize data variables
        validate_non_negative_index("sigma_b_mean", "k", k);
        sigma_b_mean = vector_d(static_cast<Eigen::VectorXd::Index>(k));
        stan::math::fill(sigma_b_mean,DUMMY_VAR__);
        stan::math::assign(sigma_b_mean,stan::model::rvalue(sigma_mean, stan::model::cons_list(stan::model::index_min(2), stan::model::nil_index_list()), "sigma_mean"));
        validate_non_negative_index("sigma_b_sd", "k", k);
        sigma_b_sd = vector_d(static_cast<Eigen::VectorXd::Index>(k));
        stan::math::fill(sigma_b_sd,DUMMY_VAR__);
        stan::math::assign(sigma_b_sd,stan::model::rvalue(sigma_sd, stan::model::cons_list(stan::model::index_min(2), stan::model::nil_index_list()), "sigma_sd"));
        sigma_y_mean = double(0);
        stan::math::fill(sigma_y_mean,DUMMY_VAR__);
        stan::math::assign(sigma_y_mean,get_base1(sigma_mean,1,"sigma_mean",1));
        sigma_y_sd = double(0);
        stan::math::fill(sigma_y_sd,DUMMY_VAR__);
        stan::math::assign(sigma_y_sd,get_base1(sigma_sd,1,"sigma_sd",1));

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("sigma_b", "k", k);
        num_params_r__ += k;
        ++num_params_r__;
        validate_non_negative_index("beta_raw", "k", k);
        validate_non_negative_index("beta_raw", "n", n);
        num_params_r__ += k * n;
    }

    ~model_rw_model_naive() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("sigma_b")))
            throw std::runtime_error("variable sigma_b missing");
        vals_r__ = context__.vals_r("sigma_b");
        pos__ = 0U;
        validate_non_negative_index("sigma_b", "k", k);
        context__.validate_dims("initialization", "sigma_b", "double", context__.to_vec(k));
        // generate_declaration sigma_b
        std::vector<double> sigma_b(k,double(0));
        for (int i0__ = 0U; i0__ < k; ++i0__)
            sigma_b[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < k; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,sigma_b[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_b: ") + e.what());
        }

        if (!(context__.contains_r("sigma_y")))
            throw std::runtime_error("variable sigma_y missing");
        vals_r__ = context__.vals_r("sigma_y");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_y", "double", context__.to_vec());
        // generate_declaration sigma_y
        double sigma_y(0);
        sigma_y = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_y);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_y: ") + e.what());
        }

        if (!(context__.contains_r("beta_raw")))
            throw std::runtime_error("variable beta_raw missing");
        vals_r__ = context__.vals_r("beta_raw");
        pos__ = 0U;
        validate_non_negative_index("beta_raw", "k", k);
        validate_non_negative_index("beta_raw", "n", n);
        context__.validate_dims("initialization", "beta_raw", "matrix_d", context__.to_vec(k,n));
        // generate_declaration beta_raw
        matrix_d beta_raw(static_cast<Eigen::VectorXd::Index>(k),static_cast<Eigen::VectorXd::Index>(n));
        for (int j2__ = 0U; j2__ < n; ++j2__)
            for (int j1__ = 0U; j1__ < k; ++j1__)
                beta_raw(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.matrix_unconstrain(beta_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_raw: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        vector<T__> sigma_b;
        size_t dim_sigma_b_0__ = k;
        sigma_b.reserve(dim_sigma_b_0__);
        for (size_t k_0__ = 0; k_0__ < dim_sigma_b_0__; ++k_0__) {
            if (jacobian__)
                sigma_b.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                sigma_b.push_back(in__.scalar_lb_constrain(0));
        }

        T__ sigma_y;
        (void) sigma_y;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_y = in__.scalar_lb_constrain(0,lp__);
        else
            sigma_y = in__.scalar_lb_constrain(0);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  beta_raw;
        (void) beta_raw;  // dummy to suppress unused var warning
        if (jacobian__)
            beta_raw = in__.matrix_constrain(k,n,lp__);
        else
            beta_raw = in__.matrix_constrain(k,n);


        // transformed parameters
        validate_non_negative_index("beta", "k", k);
        validate_non_negative_index("beta", "n", n);
        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  beta(static_cast<Eigen::VectorXd::Index>(k),static_cast<Eigen::VectorXd::Index>(n));
        (void) beta;  // dummy to suppress unused var warning

        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta,DUMMY_VAR__);
        validate_non_negative_index("tmp", "k", k);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  tmp(static_cast<Eigen::VectorXd::Index>(k));
        (void) tmp;  // dummy to suppress unused var warning

        stan::math::initialize(tmp, DUMMY_VAR__);
        stan::math::fill(tmp,DUMMY_VAR__);


        try {
            stan::model::assign(beta, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        add(beta_mean,elt_multiply(beta_sd,stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "beta_raw"))), 
                        "assigning variable beta");
            for (int t = 2; t <= n; ++t) {

                stan::math::assign(tmp, stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "beta"));
                stan::model::assign(beta, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            add(tmp,elt_multiply(to_vector(sigma_b),stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_raw"))), 
                            "assigning variable beta");
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < k; ++i0__) {
            for (int i1__ = 0; i1__ < n; ++i1__) {
                if (stan::math::is_uninitialized(beta(i0__,i1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']' << '[' << i1__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
        }
        for (int i0__ = 0; i0__ < k; ++i0__) {
            if (stan::math::is_uninitialized(tmp(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: tmp" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(sigma_b, sigma_b_mean, sigma_b_sd));
            lp_accum__.add(normal_log<propto__>(sigma_y, sigma_y_mean, sigma_y_sd));
            lp_accum__.add(normal_log<propto__>(to_vector(beta_raw), 0, 1));
            {
                validate_non_negative_index("mu", "n", n);
                Eigen::Matrix<T__,1,Eigen::Dynamic>  mu(static_cast<Eigen::VectorXd::Index>(n));
                (void) mu;  // dummy to suppress unused var warning

                stan::math::initialize(mu, DUMMY_VAR__);
                stan::math::fill(mu,DUMMY_VAR__);
                stan::math::assign(mu,columns_dot_product(xreg,beta));


                lp_accum__.add(normal_log<propto__>(y, mu, sigma_y));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("sigma_b");
        names__.push_back("sigma_y");
        names__.push_back("beta_raw");
        names__.push_back("beta");
        names__.push_back("tmp");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_rw_model_naive_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector<double> sigma_b;
        size_t dim_sigma_b_0__ = k;
        for (size_t k_0__ = 0; k_0__ < dim_sigma_b_0__; ++k_0__) {
            sigma_b.push_back(in__.scalar_lb_constrain(0));
        }
        double sigma_y = in__.scalar_lb_constrain(0);
        matrix_d beta_raw = in__.matrix_constrain(k,n);
        for (int k_0__ = 0; k_0__ < k; ++k_0__) {
            vars__.push_back(sigma_b[k_0__]);
        }
        vars__.push_back(sigma_y);
        for (int k_1__ = 0; k_1__ < n; ++k_1__) {
            for (int k_0__ = 0; k_0__ < k; ++k_0__) {
                vars__.push_back(beta_raw(k_0__, k_1__));
            }
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("beta", "k", k);
        validate_non_negative_index("beta", "n", n);
        matrix_d beta(static_cast<Eigen::VectorXd::Index>(k),static_cast<Eigen::VectorXd::Index>(n));
        (void) beta;  // dummy to suppress unused var warning

        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);
        validate_non_negative_index("tmp", "k", k);
        vector_d tmp(static_cast<Eigen::VectorXd::Index>(k));
        (void) tmp;  // dummy to suppress unused var warning

        stan::math::initialize(tmp, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tmp,DUMMY_VAR__);


        try {
            stan::model::assign(beta, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        add(beta_mean,elt_multiply(beta_sd,stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "beta_raw"))), 
                        "assigning variable beta");
            for (int t = 2; t <= n; ++t) {

                stan::math::assign(tmp, stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "beta"));
                stan::model::assign(beta, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            add(tmp,elt_multiply(to_vector(sigma_b),stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_raw"))), 
                            "assigning variable beta");
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_1__ = 0; k_1__ < n; ++k_1__) {
            for (int k_0__ = 0; k_0__ < k; ++k_0__) {
                vars__.push_back(beta(k_0__, k_1__));
            }
        }
        for (int k_0__ = 0; k_0__ < k; ++k_0__) {
            vars__.push_back(tmp[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities


        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_rw_model_naive";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= n; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_raw" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= n; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tmp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= n; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_raw" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= n; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= k; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tmp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

}




#endif
