// Generated by rstantools.  Do not edit by hand.

/*
    walker is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    licence is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with licence.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-1-g67504470
#include <stan/model/model_header.hpp>
namespace model_walker_lm_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 169, column 2 to column 29)",
                                                      " (in 'string', line 170, column 2 to column 33)",
                                                      " (in 'string', line 171, column 2 to column 33)",
                                                      " (in 'string', line 172, column 2 to column 24)",
                                                      " (in 'string', line 175, column 2 to column 20)",
                                                      " (in 'string', line 176, column 2 to column 42)",
                                                      " (in 'string', line 177, column 2 to column 18)",
                                                      " (in 'string', line 178, column 2 to column 15)",
                                                      " (in 'string', line 183, column 4 to column 31)",
                                                      " (in 'string', line 182, column 9 to line 184, column 3)",
                                                      " (in 'string', line 181, column 4 to column 36)",
                                                      " (in 'string', line 180, column 19 to line 182, column 3)",
                                                      " (in 'string', line 180, column 2 to line 184, column 3)",
                                                      " (in 'string', line 185, column 2 to column 17)",
                                                      " (in 'string', line 188, column 6 to column 52)",
                                                      " (in 'string', line 187, column 22 to line 189, column 5)",
                                                      " (in 'string', line 187, column 4 to line 189, column 5)",
                                                      " (in 'string', line 191, column 6 to column 56)",
                                                      " (in 'string', line 190, column 22 to line 192, column 5)",
                                                      " (in 'string', line 190, column 4 to line 192, column 5)",
                                                      " (in 'string', line 186, column 17 to line 193, column 3)",
                                                      " (in 'string', line 186, column 2 to line 193, column 3)",
                                                      " (in 'string', line 194, column 2 to column 86)",
                                                      " (in 'string', line 207, column 2 to column 33)",
                                                      " (in 'string', line 208, column 2 to column 38)",
                                                      " (in 'string', line 209, column 2 to column 37)",
                                                      " (in 'string', line 210, column 2 to column 33)",
                                                      " (in 'string', line 216, column 6 to column 61)",
                                                      " (in 'string', line 215, column 22 to line 217, column 5)",
                                                      " (in 'string', line 215, column 4 to line 217, column 5)",
                                                      " (in 'string', line 219, column 6 to column 69)",
                                                      " (in 'string', line 220, column 6 to column 44)",
                                                      " (in 'string', line 218, column 22 to line 221, column 5)",
                                                      " (in 'string', line 218, column 4 to line 221, column 5)",
                                                      " (in 'string', line 225, column 8 to column 86)",
                                                      " (in 'string', line 224, column 24 to line 226, column 7)",
                                                      " (in 'string', line 224, column 6 to line 226, column 7)",
                                                      " (in 'string', line 228, column 8 to column 67)",
                                                      " (in 'string', line 229, column 8 to column 76)",
                                                      " (in 'string', line 227, column 24 to line 230, column 7)",
                                                      " (in 'string', line 227, column 6 to line 230, column 7)",
                                                      " (in 'string', line 223, column 25 to line 231, column 5)",
                                                      " (in 'string', line 223, column 4 to line 231, column 5)",
                                                      " (in 'string', line 234, column 6 to column 91)",
                                                      " (in 'string', line 233, column 18 to line 235, column 5)",
                                                      " (in 'string', line 233, column 4 to line 235, column 5)",
                                                      " (in 'string', line 238, column 13 to column 14)",
                                                      " (in 'string', line 238, column 16 to column 17)",
                                                      " (in 'string', line 238, column 6 to line 239, column 44)",
                                                      " (in 'string', line 240, column 6 to column 34)",
                                                      " (in 'string', line 241, column 20 to column 49)",
                                                      " (in 'string', line 241, column 6 to column 49)",
                                                      " (in 'string', line 237, column 4 to line 242, column 5)",
                                                      " (in 'string', line 246, column 6 to column 68)",
                                                      " (in 'string', line 247, column 6 to column 60)",
                                                      " (in 'string', line 245, column 18 to line 248, column 5)",
                                                      " (in 'string', line 245, column 4 to line 248, column 5)",
                                                      " (in 'string', line 212, column 17 to line 249, column 3)",
                                                      " (in 'string', line 212, column 2 to line 249, column 3)",
                                                      " (in 'string', line 197, column 2 to column 54)",
                                                      " (in 'string', line 198, column 2 to column 47)",
                                                      " (in 'string', line 199, column 2 to column 53)",
                                                      " (in 'string', line 200, column 2 to column 53)",
                                                      " (in 'string', line 204, column 2 to column 34)",
                                                      " (in 'string', line 103, column 2 to column 23)",
                                                      " (in 'string', line 104, column 2 to column 21)",
                                                      " (in 'string', line 105, column 2 to column 21)",
                                                      " (in 'string', line 106, column 2 to column 17)",
                                                      " (in 'string', line 107, column 2 to column 17)",
                                                      " (in 'string', line 108, column 2 to column 17)",
                                                      " (in 'string', line 109, column 2 to column 21)",
                                                      " (in 'string', line 110, column 9 to column 10)",
                                                      " (in 'string', line 110, column 12 to column 19)",
                                                      " (in 'string', line 110, column 2 to column 32)",
                                                      " (in 'string', line 111, column 9 to column 10)",
                                                      " (in 'string', line 111, column 12 to column 13)",
                                                      " (in 'string', line 111, column 2 to column 23)",
                                                      " (in 'string', line 112, column 9 to column 10)",
                                                      " (in 'string', line 112, column 2 to column 14)",
                                                      " (in 'string', line 113, column 22 to column 23)",
                                                      " (in 'string', line 113, column 2 to column 25)",
                                                      " (in 'string', line 114, column 2 to column 30)",
                                                      " (in 'string', line 115, column 2 to column 29)",
                                                      " (in 'string', line 117, column 2 to column 23)",
                                                      " (in 'string', line 118, column 2 to column 30)",
                                                      " (in 'string', line 119, column 2 to column 21)",
                                                      " (in 'string', line 120, column 2 to column 28)",
                                                      " (in 'string', line 121, column 2 to column 21)",
                                                      " (in 'string', line 122, column 2 to column 28)",
                                                      " (in 'string', line 124, column 2 to column 32)",
                                                      " (in 'string', line 125, column 2 to column 32)",
                                                      " (in 'string', line 126, column 2 to column 31)",
                                                      " (in 'string', line 127, column 2 to column 31)",
                                                      " (in 'string', line 129, column 2 to column 24)",
                                                      " (in 'string', line 130, column 2 to column 22)",
                                                      " (in 'string', line 131, column 9 to column 10)",
                                                      " (in 'string', line 131, column 2 to column 20)",
                                                      " (in 'string', line 132, column 9 to column 14)",
                                                      " (in 'string', line 132, column 16 to column 17)",
                                                      " (in 'string', line 132, column 2 to column 29)",
                                                      " (in 'string', line 133, column 9 to column 14)",
                                                      " (in 'string', line 133, column 16 to column 17)",
                                                      " (in 'string', line 133, column 2 to column 29)",
                                                      " (in 'string', line 137, column 14 to column 42)",
                                                      " (in 'string', line 137, column 2 to column 44)",
                                                      " (in 'string', line 138, column 9 to column 10)",
                                                      " (in 'string', line 138, column 2 to column 15)",
                                                      " (in 'string', line 139, column 9 to column 10)",
                                                      " (in 'string', line 139, column 12 to column 13)",
                                                      " (in 'string', line 139, column 2 to column 42)",
                                                      " (in 'string', line 140, column 9 to column 10)",
                                                      " (in 'string', line 140, column 12 to column 13)",
                                                      " (in 'string', line 140, column 2 to column 52)",
                                                      " (in 'string', line 141, column 9 to column 10)",
                                                      " (in 'string', line 141, column 2 to column 42)",
                                                      " (in 'string', line 144, column 4 to column 15)",
                                                      " (in 'string', line 147, column 8 to column 20)",
                                                      " (in 'string', line 148, column 8 to column 24)",
                                                      " (in 'string', line 146, column 25 to line 149, column 7)",
                                                      " (in 'string', line 146, column 6 to line 149, column 7)",
                                                      " (in 'string', line 145, column 22 to line 150, column 5)",
                                                      " (in 'string', line 145, column 4 to line 150, column 5)",
                                                      " (in 'string', line 143, column 2 to line 151, column 3)",
                                                      " (in 'string', line 153, column 4 to column 67)",
                                                      " (in 'string', line 152, column 16 to line 154, column 3)",
                                                      " (in 'string', line 152, column 2 to line 154, column 3)",
                                                      " (in 'string', line 156, column 4 to column 26)",
                                                      " (in 'string', line 157, column 4 to column 29)",
                                                      " (in 'string', line 155, column 20 to line 158, column 3)",
                                                      " (in 'string', line 155, column 2 to line 158, column 3)",
                                                      " (in 'string', line 160, column 4 to column 26)",
                                                      " (in 'string', line 161, column 4 to column 29)",
                                                      " (in 'string', line 159, column 26 to line 162, column 3)",
                                                      " (in 'string', line 159, column 2 to line 162, column 3)",
                                                      " (in 'string', line 164, column 4 to column 20)",
                                                      " (in 'string', line 165, column 4 to column 23)",
                                                      " (in 'string', line 163, column 22 to line 166, column 3)",
                                                      " (in 'string', line 163, column 2 to line 166, column 3)",
                                                      " (in 'string', line 169, column 9 to column 16)",
                                                      " (in 'string', line 170, column 26 to column 31)",
                                                      " (in 'string', line 171, column 26 to column 31)",
                                                      " (in 'string', line 175, column 9 to column 10)",
                                                      " (in 'string', line 176, column 9 to column 10)",
                                                      " (in 'string', line 176, column 12 to column 13)",
                                                      " (in 'string', line 177, column 9 to column 10)",
                                                      " (in 'string', line 178, column 9 to column 10)",
                                                      " (in 'string', line 207, column 9 to column 25)",
                                                      " (in 'string', line 208, column 9 to column 10)",
                                                      " (in 'string', line 208, column 12 to column 28)",
                                                      " (in 'string', line 209, column 9 to column 14)",
                                                      " (in 'string', line 209, column 16 to column 32)",
                                                      " (in 'string', line 210, column 9 to column 25)",
                                                      " (in 'string', line 9, column 4 to column 23)",
                                                      " (in 'string', line 10, column 4 to column 20)",
                                                      " (in 'string', line 11, column 4 to column 21)",
                                                      " (in 'string', line 12, column 11 to column 12)",
                                                      " (in 'string', line 12, column 4 to column 58)",
                                                      " (in 'string', line 14, column 11 to column 12)",
                                                      " (in 'string', line 14, column 4 to column 21)",
                                                      " (in 'string', line 15, column 11 to column 12)",
                                                      " (in 'string', line 15, column 14 to column 15)",
                                                      " (in 'string', line 15, column 4 to column 24)",
                                                      " (in 'string', line 17, column 4 to column 30)",
                                                      " (in 'string', line 20, column 6 to column 68)",
                                                      " (in 'string', line 32, column 8 to column 19)",
                                                      " (in 'string', line 33, column 8 to column 34)",
                                                      " (in 'string', line 35, column 10 to column 30)",
                                                      " (in 'string', line 34, column 23 to line 36, column 9)",
                                                      " (in 'string', line 34, column 8 to line 36, column 9)",
                                                      " (in 'string', line 31, column 13 to line 37, column 7)",
                                                      " (in 'string', line 23, column 8 to column 59)",
                                                      " (in 'string', line 24, column 15 to column 16)",
                                                      " (in 'string', line 24, column 8 to column 50)",
                                                      " (in 'string', line 25, column 8 to column 29)",
                                                      " (in 'string', line 26, column 8 to column 47)",
                                                      " (in 'string', line 28, column 10 to column 30)",
                                                      " (in 'string', line 27, column 23 to line 29, column 9)",
                                                      " (in 'string', line 27, column 8 to line 29, column 9)",
                                                      " (in 'string', line 30, column 8 to column 57)",
                                                      " (in 'string', line 22, column 26 to line 31, column 7)",
                                                      " (in 'string', line 22, column 6 to line 37, column 7)",
                                                      " (in 'string', line 19, column 19 to line 38, column 5)",
                                                      " (in 'string', line 19, column 4 to line 38, column 5)",
                                                      " (in 'string', line 39, column 4 to column 18)",
                                                      " (in 'string', line 7, column 54 to line 41, column 3)",
                                                      " (in 'string', line 46, column 4 to column 23)",
                                                      " (in 'string', line 47, column 4 to column 20)",
                                                      " (in 'string', line 48, column 4 to column 21)",
                                                      " (in 'string', line 49, column 11 to column 12)",
                                                      " (in 'string', line 49, column 4 to column 21)",
                                                      " (in 'string', line 50, column 11 to column 12)",
                                                      " (in 'string', line 50, column 14 to column 15)",
                                                      " (in 'string', line 50, column 4 to column 24)",
                                                      " (in 'string', line 51, column 11 to column 12)",
                                                      " (in 'string', line 51, column 4 to column 16)",
                                                      " (in 'string', line 52, column 11 to column 12)",
                                                      " (in 'string', line 52, column 4 to column 16)",
                                                      " (in 'string', line 53, column 11 to column 12)",
                                                      " (in 'string', line 53, column 14 to column 15)",
                                                      " (in 'string', line 53, column 4 to column 19)",
                                                      " (in 'string', line 54, column 11 to column 12)",
                                                      " (in 'string', line 54, column 14 to column 19)",
                                                      " (in 'string', line 54, column 4 to column 23)",
                                                      " (in 'string', line 55, column 11 to column 12)",
                                                      " (in 'string', line 55, column 4 to column 19)",
                                                      " (in 'string', line 59, column 6 to column 66)",
                                                      " (in 'string', line 70, column 8 to column 19)",
                                                      " (in 'string', line 71, column 8 to column 34)",
                                                      " (in 'string', line 73, column 10 to column 30)",
                                                      " (in 'string', line 72, column 23 to line 74, column 9)",
                                                      " (in 'string', line 72, column 8 to line 74, column 9)",
                                                      " (in 'string', line 69, column 13 to line 75, column 7)",
                                                      " (in 'string', line 62, column 8 to column 57)",
                                                      " (in 'string', line 63, column 8 to column 48)",
                                                      " (in 'string', line 64, column 8 to column 36)",
                                                      " (in 'string', line 65, column 8 to column 58)",
                                                      " (in 'string', line 67, column 10 to column 30)",
                                                      " (in 'string', line 66, column 23 to line 68, column 9)",
                                                      " (in 'string', line 66, column 8 to line 68, column 9)",
                                                      " (in 'string', line 61, column 44 to line 69, column 7)",
                                                      " (in 'string', line 61, column 6 to line 75, column 7)",
                                                      " (in 'string', line 57, column 19 to line 76, column 5)",
                                                      " (in 'string', line 57, column 4 to line 76, column 5)",
                                                      " (in 'string', line 78, column 4 to column 33)",
                                                      " (in 'string', line 80, column 6 to column 25)",
                                                      " (in 'string', line 81, column 13 to column 14)",
                                                      " (in 'string', line 81, column 6 to column 31)",
                                                      " (in 'string', line 87, column 8 to column 26)",
                                                      " (in 'string', line 86, column 13 to line 88, column 7)",
                                                      " (in 'string', line 83, column 15 to column 16)",
                                                      " (in 'string', line 83, column 8 to column 44)",
                                                      " (in 'string', line 84, column 8 to column 30)",
                                                      " (in 'string', line 85, column 8 to column 71)",
                                                      " (in 'string', line 82, column 43 to line 86, column 7)",
                                                      " (in 'string', line 82, column 6 to line 88, column 7)",
                                                      " (in 'string', line 79, column 20 to line 89, column 5)",
                                                      " (in 'string', line 79, column 4 to line 89, column 5)",
                                                      " (in 'string', line 91, column 4 to column 17)",
                                                      " (in 'string', line 92, column 4 to column 27)",
                                                      " (in 'string', line 94, column 13 to column 14)",
                                                      " (in 'string', line 94, column 6 to column 30)",
                                                      " (in 'string', line 95, column 13 to column 14)",
                                                      " (in 'string', line 95, column 6 to column 29)",
                                                      " (in 'string', line 96, column 6 to column 41)",
                                                      " (in 'string', line 93, column 19 to line 97, column 5)",
                                                      " (in 'string', line 93, column 4 to line 97, column 5)",
                                                      " (in 'string', line 98, column 4 to column 23)",
                                                      " (in 'string', line 44, column 53 to line 99, column 3)"};
template <typename T0__, typename T2__, typename T3__, typename T4__,
typename T5__, typename T6__, typename T7__, typename T8__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T2__>,
stan::value_type_t<T3__>, T4__,
stan::value_type_t<T5__>, stan::promote_args_t<stan::value_type_t<T6__>,
stan::value_type_t<T7__>,
stan::value_type_t<T8__>>>, -1, 1>
gaussian_filter(const T0__& y_arg__, const std::vector<int>& y_miss,
                const T2__& a1_arg__, const T3__& P1_arg__, const T4__& Ht,
                const T5__& Tt_arg__, const T6__& Rt_arg__,
                const T7__& xreg_arg__, const T8__& gamma2_y_arg__,
                std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T2__>,
          stan::value_type_t<T3__>,
          T4__,
          stan::value_type_t<T5__>, stan::promote_args_t<stan::value_type_t<T6__>,
          stan::value_type_t<T7__>,
          stan::value_type_t<T8__>>>;
  const auto& y = to_ref(y_arg__);
  const auto& a1 = to_ref(a1_arg__);
  const auto& P1 = to_ref(P1_arg__);
  const auto& Tt = to_ref(Tt_arg__);
  const auto& Rt = to_ref(Rt_arg__);
  const auto& xreg = to_ref(xreg_arg__);
  const auto& gamma2_y = to_ref(gamma2_y_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int k;
    k = std::numeric_limits<int>::min();
    
    current_statement__ = 153;
    k = rows(xreg);
    int n;
    n = std::numeric_limits<int>::min();
    
    current_statement__ = 154;
    n = rows(y);
    int m;
    m = std::numeric_limits<int>::min();
    
    current_statement__ = 155;
    m = rows(a1);
    current_statement__ = 156;
    validate_non_negative_index("loglik", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> loglik;
    loglik = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(loglik, DUMMY_VAR__);
    
    current_statement__ = 157;
    assign(loglik, nil_index_list(),
      rep_vector(stan::math::negative_infinity(), n),
      "assigning variable loglik");
    current_statement__ = 158;
    validate_non_negative_index("x", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, 1> x;
    x = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
    stan::math::fill(x, DUMMY_VAR__);
    
    current_statement__ = 159;
    assign(x, nil_index_list(), a1, "assigning variable x");
    current_statement__ = 160;
    validate_non_negative_index("P", "m", m);
    current_statement__ = 161;
    validate_non_negative_index("P", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, -1> P;
    P = Eigen::Matrix<local_scalar_t__, -1, -1>(m, m);
    stan::math::fill(P, DUMMY_VAR__);
    
    current_statement__ = 162;
    assign(P, nil_index_list(), P1, "assigning variable P");
    local_scalar_t__ log2pi;
    log2pi = DUMMY_VAR__;
    
    current_statement__ = 163;
    log2pi = stan::math::log((2 * stan::math::pi()));
    current_statement__ = 183;
    for (int t = 1; t <= n; ++t) {
      local_scalar_t__ F;
      F = DUMMY_VAR__;
      
      current_statement__ = 164;
      F = (quad_form(
             rvalue(P,
               cons_list(index_min_max(1, k),
                 cons_list(index_min_max(1, k), nil_index_list())), "P"),
             rvalue(xreg,
               cons_list(index_omni(),
                 cons_list(index_uni(t), nil_index_list())), "xreg")) +
            (gamma2_y[(t - 1)] * Ht));
      current_statement__ = 181;
      if (logical_eq(y_miss[(t - 1)], 0)) {
        local_scalar_t__ v;
        v = DUMMY_VAR__;
        
        current_statement__ = 171;
        v = (y[(t - 1)] -
              dot_product(
                rvalue(xreg,
                  cons_list(index_omni(),
                    cons_list(index_uni(t), nil_index_list())), "xreg"),
                head(x, k)));
        current_statement__ = 172;
        validate_non_negative_index("K", "m", m);
        Eigen::Matrix<local_scalar_t__, -1, 1> K;
        K = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
        stan::math::fill(K, DUMMY_VAR__);
        
        current_statement__ = 173;
        assign(K, nil_index_list(),
          divide(
            multiply(
              rvalue(P,
                cons_list(index_min_max(1, m),
                  cons_list(index_min_max(1, k), nil_index_list())), "P"),
              rvalue(xreg,
                cons_list(index_omni(),
                  cons_list(index_uni(t), nil_index_list())), "xreg")), F),
          "assigning variable K");
        current_statement__ = 174;
        assign(x, nil_index_list(),
          multiply(Tt, add(stan::model::deep_copy(x), multiply(K, v))),
          "assigning variable x");
        current_statement__ = 175;
        assign(P, nil_index_list(),
          quad_form_sym(
            subtract(stan::model::deep_copy(P),
              multiply(multiply(K, transpose(K)), F)), transpose(Tt)),
          "assigning variable P");
        current_statement__ = 178;
        for (int i = 1; i <= m; ++i) {
          current_statement__ = 176;
          assign(P,
            cons_list(index_uni(i),
              cons_list(index_uni(i), nil_index_list())),
            (rvalue(P,
               cons_list(index_uni(i),
                 cons_list(index_uni(i), nil_index_list())), "P") +
              rvalue(Rt,
                cons_list(index_uni(i),
                  cons_list(index_uni(t), nil_index_list())), "Rt")),
            "assigning variable P");}
        current_statement__ = 179;
        assign(loglik, cons_list(index_uni(t), nil_index_list()),
          (-0.5 * ((log2pi + stan::math::log(F)) + ((v * v) / F))),
          "assigning variable loglik");
      } else {
        current_statement__ = 165;
        assign(x, nil_index_list(), multiply(Tt, stan::model::deep_copy(x)),
          "assigning variable x");
        current_statement__ = 166;
        assign(P, nil_index_list(),
          quad_form_sym(stan::model::deep_copy(P), transpose(Tt)),
          "assigning variable P");
        current_statement__ = 169;
        for (int i = 1; i <= m; ++i) {
          current_statement__ = 167;
          assign(P,
            cons_list(index_uni(i),
              cons_list(index_uni(i), nil_index_list())),
            (rvalue(P,
               cons_list(index_uni(i),
                 cons_list(index_uni(i), nil_index_list())), "P") +
              rvalue(Rt,
                cons_list(index_uni(i),
                  cons_list(index_uni(t), nil_index_list())), "Rt")),
            "assigning variable P");}
      }}
    current_statement__ = 184;
    return loglik;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct gaussian_filter_functor__ {
template <typename T0__, typename T2__, typename T3__, typename T4__,
typename T5__, typename T6__, typename T7__, typename T8__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T2__>,
stan::value_type_t<T3__>, T4__,
stan::value_type_t<T5__>, stan::promote_args_t<stan::value_type_t<T6__>,
stan::value_type_t<T7__>,
stan::value_type_t<T8__>>>, -1, 1>
operator()(const T0__& y, const std::vector<int>& y_miss, const T2__& a1,
           const T3__& P1, const T4__& Ht, const T5__& Tt, const T6__& Rt,
           const T7__& xreg, const T8__& gamma2_y, std::ostream* pstream__)  const 
{
return gaussian_filter(y, y_miss, a1, P1, Ht, Tt, Rt, xreg, gamma2_y,
         pstream__);
}
};
template <typename T0__, typename T2__, typename T3__, typename T4__,
typename T5__, typename T6__, typename T7__, typename T8__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T2__>,
stan::value_type_t<T3__>, T4__,
stan::value_type_t<T5__>, stan::promote_args_t<stan::value_type_t<T6__>,
stan::value_type_t<T7__>,
stan::value_type_t<T8__>>>, -1, -1>
gaussian_smoother(const T0__& y_arg__, const std::vector<int>& y_miss,
                  const T2__& a1_arg__, const T3__& P1_arg__, const T4__& Ht,
                  const T5__& Tt_arg__, const T6__& Rt_arg__,
                  const T7__& xreg_arg__, const T8__& gamma2_y_arg__,
                  std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T2__>,
          stan::value_type_t<T3__>,
          T4__,
          stan::value_type_t<T5__>, stan::promote_args_t<stan::value_type_t<T6__>,
          stan::value_type_t<T7__>,
          stan::value_type_t<T8__>>>;
  const auto& y = to_ref(y_arg__);
  const auto& a1 = to_ref(a1_arg__);
  const auto& P1 = to_ref(P1_arg__);
  const auto& Tt = to_ref(Tt_arg__);
  const auto& Rt = to_ref(Rt_arg__);
  const auto& xreg = to_ref(xreg_arg__);
  const auto& gamma2_y = to_ref(gamma2_y_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int k;
    k = std::numeric_limits<int>::min();
    
    current_statement__ = 186;
    k = rows(xreg);
    int n;
    n = std::numeric_limits<int>::min();
    
    current_statement__ = 187;
    n = rows(y);
    int m;
    m = std::numeric_limits<int>::min();
    
    current_statement__ = 188;
    m = rows(a1);
    current_statement__ = 189;
    validate_non_negative_index("x", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, 1> x;
    x = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
    stan::math::fill(x, DUMMY_VAR__);
    
    current_statement__ = 190;
    assign(x, nil_index_list(), a1, "assigning variable x");
    current_statement__ = 191;
    validate_non_negative_index("P", "m", m);
    current_statement__ = 192;
    validate_non_negative_index("P", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, -1> P;
    P = Eigen::Matrix<local_scalar_t__, -1, -1>(m, m);
    stan::math::fill(P, DUMMY_VAR__);
    
    current_statement__ = 193;
    assign(P, nil_index_list(), P1, "assigning variable P");
    current_statement__ = 194;
    validate_non_negative_index("v", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> v;
    v = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(v, DUMMY_VAR__);
    
    current_statement__ = 196;
    validate_non_negative_index("F", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> F;
    F = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(F, DUMMY_VAR__);
    
    current_statement__ = 198;
    validate_non_negative_index("K", "m", m);
    current_statement__ = 199;
    validate_non_negative_index("K", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, -1> K;
    K = Eigen::Matrix<local_scalar_t__, -1, -1>(m, n);
    stan::math::fill(K, DUMMY_VAR__);
    
    current_statement__ = 201;
    validate_non_negative_index("r", "m", m);
    current_statement__ = 202;
    validate_non_negative_index("r", "n + 1", (n + 1));
    Eigen::Matrix<local_scalar_t__, -1, -1> r;
    r = Eigen::Matrix<local_scalar_t__, -1, -1>(m, (n + 1));
    stan::math::fill(r, DUMMY_VAR__);
    
    current_statement__ = 204;
    validate_non_negative_index("tmpr", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, 1> tmpr;
    tmpr = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
    stan::math::fill(tmpr, DUMMY_VAR__);
    
    current_statement__ = 223;
    for (int t = 1; t <= n; ++t) {
      current_statement__ = 206;
      assign(F, cons_list(index_uni(t), nil_index_list()),
        (quad_form(
           rvalue(P,
             cons_list(index_min_max(1, k),
               cons_list(index_min_max(1, k), nil_index_list())), "P"),
           rvalue(xreg,
             cons_list(index_omni(),
               cons_list(index_uni(t), nil_index_list())), "xreg")) +
          (gamma2_y[(t - 1)] * Ht)), "assigning variable F");
      current_statement__ = 221;
      if ((primitive_value(logical_eq(y_miss[(t - 1)], 0)) &&
          primitive_value(logical_gt(F[(t - 1)], 1.0e-12)))) {
        current_statement__ = 213;
        assign(v, cons_list(index_uni(t), nil_index_list()),
          (y[(t - 1)] -
            dot_product(
              rvalue(xreg,
                cons_list(index_omni(),
                  cons_list(index_uni(t), nil_index_list())), "xreg"),
              head(x, k))), "assigning variable v");
        current_statement__ = 214;
        assign(K,
          cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
          divide(
            multiply(
              rvalue(P,
                cons_list(index_min_max(1, m),
                  cons_list(index_min_max(1, k), nil_index_list())), "P"),
              rvalue(xreg,
                cons_list(index_omni(),
                  cons_list(index_uni(t), nil_index_list())), "xreg")),
            F[(t - 1)]), "assigning variable K");
        current_statement__ = 215;
        assign(x, nil_index_list(),
          multiply(Tt,
            add(stan::model::deep_copy(x),
              multiply(
                rvalue(K,
                  cons_list(index_omni(),
                    cons_list(index_uni(t), nil_index_list())), "K"),
                v[(t - 1)]))), "assigning variable x");
        current_statement__ = 216;
        assign(P, nil_index_list(),
          quad_form_sym(
            subtract(stan::model::deep_copy(P),
              multiply(
                multiply(
                  rvalue(K,
                    cons_list(index_omni(),
                      cons_list(index_uni(t), nil_index_list())), "K"),
                  transpose(
                    rvalue(K,
                      cons_list(index_omni(),
                        cons_list(index_uni(t), nil_index_list())), "K"))),
                F[(t - 1)])), transpose(Tt)), "assigning variable P");
        current_statement__ = 219;
        for (int i = 1; i <= m; ++i) {
          current_statement__ = 217;
          assign(P,
            cons_list(index_uni(i),
              cons_list(index_uni(i), nil_index_list())),
            (rvalue(P,
               cons_list(index_uni(i),
                 cons_list(index_uni(i), nil_index_list())), "P") +
              rvalue(Rt,
                cons_list(index_uni(i),
                  cons_list(index_uni(t), nil_index_list())), "Rt")),
            "assigning variable P");}
      } else {
        current_statement__ = 207;
        assign(x, nil_index_list(), multiply(Tt, stan::model::deep_copy(x)),
          "assigning variable x");
        current_statement__ = 208;
        assign(P, nil_index_list(),
          quad_form_sym(stan::model::deep_copy(P), transpose(Tt)),
          "assigning variable P");
        current_statement__ = 211;
        for (int i = 1; i <= m; ++i) {
          current_statement__ = 209;
          assign(P,
            cons_list(index_uni(i),
              cons_list(index_uni(i), nil_index_list())),
            (rvalue(P,
               cons_list(index_uni(i),
                 cons_list(index_uni(i), nil_index_list())), "P") +
              rvalue(Rt,
                cons_list(index_uni(i),
                  cons_list(index_uni(t), nil_index_list())), "Rt")),
            "assigning variable P");}
      }}
    current_statement__ = 224;
    assign(r,
      cons_list(index_omni(),
        cons_list(index_uni((n + 1)), nil_index_list())), rep_vector(0.0, m),
      "assigning variable r");
    current_statement__ = 237;
    for (int tt = 1; tt <= n; ++tt) {
      int t;
      t = std::numeric_limits<int>::min();
      
      current_statement__ = 225;
      t = ((n + 1) - tt);
      current_statement__ = 226;
      validate_non_negative_index("tmp", "m", m);
      Eigen::Matrix<local_scalar_t__, -1, 1> tmp;
      tmp = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(tmp, DUMMY_VAR__);
      
      current_statement__ = 227;
      assign(tmp, nil_index_list(),
        rvalue(r,
          cons_list(index_omni(),
            cons_list(index_uni((t + 1)), nil_index_list())), "r"),
        "assigning variable tmp");
      current_statement__ = 235;
      if ((primitive_value(logical_eq(y_miss[(t - 1)], 0)) &&
          primitive_value(logical_gt(F[(t - 1)], 1.0e-12)))) {
        current_statement__ = 230;
        validate_non_negative_index("tmp2", "m", m);
        Eigen::Matrix<local_scalar_t__, -1, 1> tmp2;
        tmp2 = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
        stan::math::fill(tmp2, DUMMY_VAR__);
        
        current_statement__ = 231;
        assign(tmp2, nil_index_list(), rep_vector(0.0, m),
          "assigning variable tmp2");
        current_statement__ = 232;
        assign(tmp2, cons_list(index_min_max(1, k), nil_index_list()),
          rvalue(xreg,
            cons_list(index_omni(),
              cons_list(index_uni(t), nil_index_list())), "xreg"),
          "assigning variable tmp2");
        current_statement__ = 233;
        assign(r,
          cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
          add(divide(multiply(tmp2, v[(t - 1)]), F[(t - 1)]),
            multiply(
              transpose(
                subtract(Tt,
                  multiply(
                    multiply(Tt,
                      rvalue(K,
                        cons_list(index_omni(),
                          cons_list(index_uni(t), nil_index_list())), "K")),
                    transpose(tmp2)))), tmp)), "assigning variable r");
      } else {
        current_statement__ = 228;
        assign(r,
          cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
          multiply(transpose(Tt), tmp), "assigning variable r");
      }}
    current_statement__ = 238;
    assign(tmpr, nil_index_list(),
      rvalue(r,
        cons_list(index_omni(), cons_list(index_uni(1), nil_index_list())),
        "r"), "assigning variable tmpr");
    current_statement__ = 239;
    assign(r,
      cons_list(index_omni(), cons_list(index_uni(1), nil_index_list())),
      add(a1, multiply(P1, tmpr)), "assigning variable r");
    current_statement__ = 246;
    for (int t = 2; t <= n; ++t) {
      current_statement__ = 240;
      validate_non_negative_index("tmp", "m", m);
      Eigen::Matrix<local_scalar_t__, -1, 1> tmp;
      tmp = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(tmp, DUMMY_VAR__);
      
      current_statement__ = 241;
      assign(tmp, nil_index_list(),
        rvalue(r,
          cons_list(index_omni(),
            cons_list(index_uni((t - 1)), nil_index_list())), "r"),
        "assigning variable tmp");
      current_statement__ = 242;
      validate_non_negative_index("tmp2", "m", m);
      Eigen::Matrix<local_scalar_t__, -1, 1> tmp2;
      tmp2 = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(tmp2, DUMMY_VAR__);
      
      current_statement__ = 243;
      assign(tmp2, nil_index_list(),
        rvalue(r,
          cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
          "r"), "assigning variable tmp2");
      current_statement__ = 244;
      assign(r,
        cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
        add(multiply(Tt, tmp),
          elt_multiply(
            rvalue(Rt,
              cons_list(index_omni(),
                cons_list(index_uni(t), nil_index_list())), "Rt"), tmp2)),
        "assigning variable r");}
    current_statement__ = 247;
    return rvalue(r,
             cons_list(index_min_max(1, m),
               cons_list(index_min_max(1, n), nil_index_list())), "r");
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct gaussian_smoother_functor__ {
template <typename T0__, typename T2__, typename T3__, typename T4__,
typename T5__, typename T6__, typename T7__, typename T8__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T2__>,
stan::value_type_t<T3__>, T4__,
stan::value_type_t<T5__>, stan::promote_args_t<stan::value_type_t<T6__>,
stan::value_type_t<T7__>,
stan::value_type_t<T8__>>>, -1, -1>
operator()(const T0__& y, const std::vector<int>& y_miss, const T2__& a1,
           const T3__& P1, const T4__& Ht, const T5__& Tt, const T6__& Rt,
           const T7__& xreg, const T8__& gamma2_y, std::ostream* pstream__)  const 
{
return gaussian_smoother(y, y_miss, a1, P1, Ht, Tt, Rt, xreg, gamma2_y,
         pstream__);
}
};
#include <stan_meta_header.hpp>
class model_walker_lm final : public model_base_crtp<model_walker_lm> {
private:
  int k_fixed;
  int k_rw1;
  int k_rw2;
  int m;
  int k;
  int n;
  int n_lfo;
  Eigen::Matrix<double, -1, -1> xreg_fixed;
  Eigen::Matrix<double, -1, -1> xreg_rw;
  Eigen::Matrix<double, -1, 1> y;
  std::vector<int> y_miss;
  double sigma_y_shape;
  double sigma_y_rate;
  double beta_fixed_mean;
  double beta_fixed_sd;
  double beta_rw1_mean;
  double beta_rw1_sd;
  double beta_rw2_mean;
  double beta_rw2_sd;
  double sigma_rw1_shape;
  double sigma_rw2_shape;
  double sigma_rw1_rate;
  double sigma_rw2_rate;
  double nu_mean;
  double nu_sd;
  Eigen::Matrix<double, -1, 1> gamma_y;
  Eigen::Matrix<double, -1, -1> gamma_rw1;
  Eigen::Matrix<double, -1, -1> gamma_rw2;
  std::vector<int> obs_idx;
  Eigen::Matrix<double, -1, 1> a1;
  Eigen::Matrix<double, -1, -1> P1;
  Eigen::Matrix<double, -1, -1> Tt;
  Eigen::Matrix<double, -1, 1> gamma2_y;
  int y_rep_1dim__;
  int beta_rw_2dim__;
  int nu_2dim__;
  int y_fit_1dim__;
 
public:
  ~model_walker_lm() { }
  
  inline std::string model_name() const final { return "model_walker_lm"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-1-g67504470", "stancflags = "};
  }
  
  
  model_walker_lm(stan::io::var_context& context__,
                  unsigned int random_seed__ = 0,
                  std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_walker_lm_namespace::model_walker_lm";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 65;
      context__.validate_dims("data initialization","k_fixed","int",
          context__.to_vec());
      k_fixed = std::numeric_limits<int>::min();
      
      current_statement__ = 65;
      k_fixed = context__.vals_i("k_fixed")[(1 - 1)];
      current_statement__ = 65;
      current_statement__ = 65;
      check_greater_or_equal(function__, "k_fixed", k_fixed, 0);
      current_statement__ = 66;
      context__.validate_dims("data initialization","k_rw1","int",
          context__.to_vec());
      k_rw1 = std::numeric_limits<int>::min();
      
      current_statement__ = 66;
      k_rw1 = context__.vals_i("k_rw1")[(1 - 1)];
      current_statement__ = 66;
      current_statement__ = 66;
      check_greater_or_equal(function__, "k_rw1", k_rw1, 0);
      current_statement__ = 67;
      context__.validate_dims("data initialization","k_rw2","int",
          context__.to_vec());
      k_rw2 = std::numeric_limits<int>::min();
      
      current_statement__ = 67;
      k_rw2 = context__.vals_i("k_rw2")[(1 - 1)];
      current_statement__ = 67;
      current_statement__ = 67;
      check_greater_or_equal(function__, "k_rw2", k_rw2, 0);
      current_statement__ = 68;
      context__.validate_dims("data initialization","m","int",
          context__.to_vec());
      m = std::numeric_limits<int>::min();
      
      current_statement__ = 68;
      m = context__.vals_i("m")[(1 - 1)];
      current_statement__ = 68;
      current_statement__ = 68;
      check_greater_or_equal(function__, "m", m, 0);
      current_statement__ = 69;
      context__.validate_dims("data initialization","k","int",
          context__.to_vec());
      k = std::numeric_limits<int>::min();
      
      current_statement__ = 69;
      k = context__.vals_i("k")[(1 - 1)];
      current_statement__ = 69;
      current_statement__ = 69;
      check_greater_or_equal(function__, "k", k, 0);
      current_statement__ = 70;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec());
      n = std::numeric_limits<int>::min();
      
      current_statement__ = 70;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 70;
      current_statement__ = 70;
      check_greater_or_equal(function__, "n", n, 1);
      current_statement__ = 71;
      context__.validate_dims("data initialization","n_lfo","int",
          context__.to_vec());
      n_lfo = std::numeric_limits<int>::min();
      
      current_statement__ = 71;
      n_lfo = context__.vals_i("n_lfo")[(1 - 1)];
      current_statement__ = 71;
      current_statement__ = 71;
      check_greater_or_equal(function__, "n_lfo", n_lfo, 1);
      current_statement__ = 72;
      validate_non_negative_index("xreg_fixed", "n", n);
      current_statement__ = 73;
      validate_non_negative_index("xreg_fixed", "k_fixed", k_fixed);
      current_statement__ = 74;
      context__.validate_dims("data initialization","xreg_fixed","double",
          context__.to_vec(n, k_fixed));
      xreg_fixed = Eigen::Matrix<double, -1, -1>(n, k_fixed);
      stan::math::fill(xreg_fixed, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xreg_fixed_flat__;
        current_statement__ = 74;
        assign(xreg_fixed_flat__, nil_index_list(),
          context__.vals_r("xreg_fixed"),
          "assigning variable xreg_fixed_flat__");
        current_statement__ = 74;
        pos__ = 1;
        current_statement__ = 74;
        for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
          current_statement__ = 74;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 74;
            assign(xreg_fixed,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xreg_fixed_flat__[(pos__ - 1)], "assigning variable xreg_fixed");
            current_statement__ = 74;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 75;
      validate_non_negative_index("xreg_rw", "k", k);
      current_statement__ = 76;
      validate_non_negative_index("xreg_rw", "n", n);
      current_statement__ = 77;
      context__.validate_dims("data initialization","xreg_rw","double",
          context__.to_vec(k, n));
      xreg_rw = Eigen::Matrix<double, -1, -1>(k, n);
      stan::math::fill(xreg_rw, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xreg_rw_flat__;
        current_statement__ = 77;
        assign(xreg_rw_flat__, nil_index_list(), context__.vals_r("xreg_rw"),
          "assigning variable xreg_rw_flat__");
        current_statement__ = 77;
        pos__ = 1;
        current_statement__ = 77;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 77;
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            current_statement__ = 77;
            assign(xreg_rw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xreg_rw_flat__[(pos__ - 1)], "assigning variable xreg_rw");
            current_statement__ = 77;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 78;
      validate_non_negative_index("y", "n", n);
      current_statement__ = 79;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(n));
      y = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 79;
        assign(y_flat__, nil_index_list(), context__.vals_r("y"),
          "assigning variable y_flat__");
        current_statement__ = 79;
        pos__ = 1;
        current_statement__ = 79;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 79;
          assign(y, cons_list(index_uni(sym1__), nil_index_list()),
            y_flat__[(pos__ - 1)], "assigning variable y");
          current_statement__ = 79;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 80;
      validate_non_negative_index("y_miss", "n", n);
      current_statement__ = 81;
      context__.validate_dims("data initialization","y_miss","int",
          context__.to_vec(n));
      y_miss = std::vector<int>(n, std::numeric_limits<int>::min());
      
      current_statement__ = 81;
      assign(y_miss, nil_index_list(), context__.vals_i("y_miss"),
        "assigning variable y_miss");
      current_statement__ = 81;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 81;
        current_statement__ = 81;
        check_greater_or_equal(function__, "y_miss[sym1__]",
                               y_miss[(sym1__ - 1)], 0);}
      current_statement__ = 82;
      context__.validate_dims("data initialization","sigma_y_shape","double",
          context__.to_vec());
      sigma_y_shape = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 82;
      sigma_y_shape = context__.vals_r("sigma_y_shape")[(1 - 1)];
      current_statement__ = 82;
      current_statement__ = 82;
      check_greater_or_equal(function__, "sigma_y_shape", sigma_y_shape, 0);
      current_statement__ = 83;
      context__.validate_dims("data initialization","sigma_y_rate","double",
          context__.to_vec());
      sigma_y_rate = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 83;
      sigma_y_rate = context__.vals_r("sigma_y_rate")[(1 - 1)];
      current_statement__ = 83;
      current_statement__ = 83;
      check_greater_or_equal(function__, "sigma_y_rate", sigma_y_rate, 0);
      current_statement__ = 84;
      context__.validate_dims("data initialization","beta_fixed_mean",
          "double",context__.to_vec());
      beta_fixed_mean = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 84;
      beta_fixed_mean = context__.vals_r("beta_fixed_mean")[(1 - 1)];
      current_statement__ = 85;
      context__.validate_dims("data initialization","beta_fixed_sd","double",
          context__.to_vec());
      beta_fixed_sd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 85;
      beta_fixed_sd = context__.vals_r("beta_fixed_sd")[(1 - 1)];
      current_statement__ = 85;
      current_statement__ = 85;
      check_greater_or_equal(function__, "beta_fixed_sd", beta_fixed_sd, 0);
      current_statement__ = 86;
      context__.validate_dims("data initialization","beta_rw1_mean","double",
          context__.to_vec());
      beta_rw1_mean = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 86;
      beta_rw1_mean = context__.vals_r("beta_rw1_mean")[(1 - 1)];
      current_statement__ = 87;
      context__.validate_dims("data initialization","beta_rw1_sd","double",
          context__.to_vec());
      beta_rw1_sd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 87;
      beta_rw1_sd = context__.vals_r("beta_rw1_sd")[(1 - 1)];
      current_statement__ = 87;
      current_statement__ = 87;
      check_greater_or_equal(function__, "beta_rw1_sd", beta_rw1_sd, 0);
      current_statement__ = 88;
      context__.validate_dims("data initialization","beta_rw2_mean","double",
          context__.to_vec());
      beta_rw2_mean = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 88;
      beta_rw2_mean = context__.vals_r("beta_rw2_mean")[(1 - 1)];
      current_statement__ = 89;
      context__.validate_dims("data initialization","beta_rw2_sd","double",
          context__.to_vec());
      beta_rw2_sd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 89;
      beta_rw2_sd = context__.vals_r("beta_rw2_sd")[(1 - 1)];
      current_statement__ = 89;
      current_statement__ = 89;
      check_greater_or_equal(function__, "beta_rw2_sd", beta_rw2_sd, 0);
      current_statement__ = 90;
      context__.validate_dims("data initialization","sigma_rw1_shape",
          "double",context__.to_vec());
      sigma_rw1_shape = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 90;
      sigma_rw1_shape = context__.vals_r("sigma_rw1_shape")[(1 - 1)];
      current_statement__ = 90;
      current_statement__ = 90;
      check_greater_or_equal(function__, "sigma_rw1_shape", sigma_rw1_shape,
                             0);
      current_statement__ = 91;
      context__.validate_dims("data initialization","sigma_rw2_shape",
          "double",context__.to_vec());
      sigma_rw2_shape = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 91;
      sigma_rw2_shape = context__.vals_r("sigma_rw2_shape")[(1 - 1)];
      current_statement__ = 91;
      current_statement__ = 91;
      check_greater_or_equal(function__, "sigma_rw2_shape", sigma_rw2_shape,
                             0);
      current_statement__ = 92;
      context__.validate_dims("data initialization","sigma_rw1_rate",
          "double",context__.to_vec());
      sigma_rw1_rate = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 92;
      sigma_rw1_rate = context__.vals_r("sigma_rw1_rate")[(1 - 1)];
      current_statement__ = 92;
      current_statement__ = 92;
      check_greater_or_equal(function__, "sigma_rw1_rate", sigma_rw1_rate, 0);
      current_statement__ = 93;
      context__.validate_dims("data initialization","sigma_rw2_rate",
          "double",context__.to_vec());
      sigma_rw2_rate = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 93;
      sigma_rw2_rate = context__.vals_r("sigma_rw2_rate")[(1 - 1)];
      current_statement__ = 93;
      current_statement__ = 93;
      check_greater_or_equal(function__, "sigma_rw2_rate", sigma_rw2_rate, 0);
      current_statement__ = 94;
      context__.validate_dims("data initialization","nu_mean","double",
          context__.to_vec());
      nu_mean = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 94;
      nu_mean = context__.vals_r("nu_mean")[(1 - 1)];
      current_statement__ = 94;
      current_statement__ = 94;
      check_greater_or_equal(function__, "nu_mean", nu_mean, 0);
      current_statement__ = 95;
      context__.validate_dims("data initialization","nu_sd","double",
          context__.to_vec());
      nu_sd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 95;
      nu_sd = context__.vals_r("nu_sd")[(1 - 1)];
      current_statement__ = 95;
      current_statement__ = 95;
      check_greater_or_equal(function__, "nu_sd", nu_sd, 0);
      current_statement__ = 96;
      validate_non_negative_index("gamma_y", "n", n);
      current_statement__ = 97;
      context__.validate_dims("data initialization","gamma_y","double",
          context__.to_vec(n));
      gamma_y = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(gamma_y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> gamma_y_flat__;
        current_statement__ = 97;
        assign(gamma_y_flat__, nil_index_list(), context__.vals_r("gamma_y"),
          "assigning variable gamma_y_flat__");
        current_statement__ = 97;
        pos__ = 1;
        current_statement__ = 97;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 97;
          assign(gamma_y, cons_list(index_uni(sym1__), nil_index_list()),
            gamma_y_flat__[(pos__ - 1)], "assigning variable gamma_y");
          current_statement__ = 97;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 98;
      validate_non_negative_index("gamma_rw1", "k_rw1", k_rw1);
      current_statement__ = 99;
      validate_non_negative_index("gamma_rw1", "n", n);
      current_statement__ = 100;
      context__.validate_dims("data initialization","gamma_rw1","double",
          context__.to_vec(k_rw1, n));
      gamma_rw1 = Eigen::Matrix<double, -1, -1>(k_rw1, n);
      stan::math::fill(gamma_rw1, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> gamma_rw1_flat__;
        current_statement__ = 100;
        assign(gamma_rw1_flat__, nil_index_list(),
          context__.vals_r("gamma_rw1"),
          "assigning variable gamma_rw1_flat__");
        current_statement__ = 100;
        pos__ = 1;
        current_statement__ = 100;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 100;
          for (int sym2__ = 1; sym2__ <= k_rw1; ++sym2__) {
            current_statement__ = 100;
            assign(gamma_rw1,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              gamma_rw1_flat__[(pos__ - 1)], "assigning variable gamma_rw1");
            current_statement__ = 100;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 101;
      validate_non_negative_index("gamma_rw2", "k_rw2", k_rw2);
      current_statement__ = 102;
      validate_non_negative_index("gamma_rw2", "n", n);
      current_statement__ = 103;
      context__.validate_dims("data initialization","gamma_rw2","double",
          context__.to_vec(k_rw2, n));
      gamma_rw2 = Eigen::Matrix<double, -1, -1>(k_rw2, n);
      stan::math::fill(gamma_rw2, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> gamma_rw2_flat__;
        current_statement__ = 103;
        assign(gamma_rw2_flat__, nil_index_list(),
          context__.vals_r("gamma_rw2"),
          "assigning variable gamma_rw2_flat__");
        current_statement__ = 103;
        pos__ = 1;
        current_statement__ = 103;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 103;
          for (int sym2__ = 1; sym2__ <= k_rw2; ++sym2__) {
            current_statement__ = 103;
            assign(gamma_rw2,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              gamma_rw2_flat__[(pos__ - 1)], "assigning variable gamma_rw2");
            current_statement__ = 103;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 104;
      validate_non_negative_index("obs_idx",
                                  "n_lfo - sum(y_miss[1 : n_lfo])",
                                  (n_lfo -
                                    sum(
                                      rvalue(y_miss,
                                        cons_list(index_min_max(1, n_lfo),
                                          nil_index_list()), "y_miss"))));
      current_statement__ = 105;
      obs_idx = std::vector<int>((n_lfo -
                                   sum(
                                     rvalue(y_miss,
                                       cons_list(index_min_max(1, n_lfo),
                                         nil_index_list()), "y_miss"))), std::numeric_limits<int>::min());
      
      current_statement__ = 106;
      validate_non_negative_index("a1", "m", m);
      current_statement__ = 107;
      a1 = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(a1, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 108;
      validate_non_negative_index("P1", "m", m);
      current_statement__ = 109;
      validate_non_negative_index("P1", "m", m);
      current_statement__ = 110;
      P1 = Eigen::Matrix<double, -1, -1>(m, m);
      stan::math::fill(P1, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 110;
      assign(P1, nil_index_list(), rep_matrix(0.0, m, m),
        "assigning variable P1");
      current_statement__ = 111;
      validate_non_negative_index("Tt", "m", m);
      current_statement__ = 112;
      validate_non_negative_index("Tt", "m", m);
      current_statement__ = 113;
      Tt = Eigen::Matrix<double, -1, -1>(m, m);
      stan::math::fill(Tt, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 113;
      assign(Tt, nil_index_list(), diag_matrix(rep_vector(1.0, m)),
        "assigning variable Tt");
      current_statement__ = 114;
      validate_non_negative_index("gamma2_y", "n", n);
      current_statement__ = 115;
      gamma2_y = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(gamma2_y, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 115;
      assign(gamma2_y, nil_index_list(), elt_multiply(gamma_y, gamma_y),
        "assigning variable gamma2_y");
      {
        int ii;
        ii = std::numeric_limits<int>::min();
        
        current_statement__ = 116;
        ii = 0;
        current_statement__ = 122;
        for (int i = 1; i <= n_lfo; ++i) {
          current_statement__ = 120;
          if (logical_eq(y_miss[(i - 1)], 0)) {
            current_statement__ = 117;
            ii = (ii + 1);
            current_statement__ = 118;
            assign(obs_idx, cons_list(index_uni(ii), nil_index_list()), i,
              "assigning variable obs_idx");
          } }
      }
      current_statement__ = 126;
      if (logical_gt(k_rw2, 0)) {
        current_statement__ = 124;
        assign(Tt,
          cons_list(index_min_max((k_rw1 + 1), k),
            cons_list(index_min_max((k + 1), m), nil_index_list())),
          diag_matrix(rep_vector(1.0, k_rw2)), "assigning variable Tt");
      } 
      current_statement__ = 130;
      for (int i = 1; i <= k_rw1; ++i) {
        current_statement__ = 127;
        assign(a1, cons_list(index_uni(i), nil_index_list()), beta_rw1_mean,
          "assigning variable a1");
        current_statement__ = 128;
        assign(P1,
          cons_list(index_uni(i), cons_list(index_uni(i), nil_index_list())),
          pow(beta_rw1_sd, 2), "assigning variable P1");}
      current_statement__ = 134;
      for (int i = (k_rw1 + 1); i <= k; ++i) {
        current_statement__ = 131;
        assign(a1, cons_list(index_uni(i), nil_index_list()), beta_rw2_mean,
          "assigning variable a1");
        current_statement__ = 132;
        assign(P1,
          cons_list(index_uni(i), cons_list(index_uni(i), nil_index_list())),
          pow(beta_rw2_sd, 2), "assigning variable P1");}
      current_statement__ = 138;
      for (int i = (k + 1); i <= m; ++i) {
        current_statement__ = 135;
        assign(a1, cons_list(index_uni(i), nil_index_list()), nu_mean,
          "assigning variable a1");
        current_statement__ = 136;
        assign(P1,
          cons_list(index_uni(i), cons_list(index_uni(i), nil_index_list())),
          pow(nu_sd, 2), "assigning variable P1");}
      current_statement__ = 139;
      validate_non_negative_index("beta_fixed", "k_fixed", k_fixed);
      current_statement__ = 140;
      validate_non_negative_index("sigma_rw1", "k_rw1", k_rw1);
      current_statement__ = 141;
      validate_non_negative_index("sigma_rw2", "k_rw2", k_rw2);
      current_statement__ = 142;
      validate_non_negative_index("log_lik", "n", n);
      current_statement__ = 143;
      validate_non_negative_index("Rt", "m", m);
      current_statement__ = 144;
      validate_non_negative_index("Rt", "n", n);
      current_statement__ = 145;
      validate_non_negative_index("xbeta", "n", n);
      current_statement__ = 146;
      validate_non_negative_index("y_", "n", n);
      current_statement__ = 147;
      y_rep_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 147;
      y_rep_1dim__ = (n * logical_eq(n_lfo, n));
      current_statement__ = 147;
      validate_non_negative_index("y_rep", "n * (n_lfo == n)", y_rep_1dim__);
      current_statement__ = 148;
      validate_non_negative_index("beta_rw", "k", k);
      current_statement__ = 149;
      beta_rw_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 149;
      beta_rw_2dim__ = (n * logical_eq(n_lfo, n));
      current_statement__ = 149;
      validate_non_negative_index("beta_rw", "n * (n_lfo == n)",
                                  beta_rw_2dim__);
      current_statement__ = 150;
      validate_non_negative_index("nu", "k_rw2", k_rw2);
      current_statement__ = 151;
      nu_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 151;
      nu_2dim__ = (n * logical_eq(n_lfo, n));
      current_statement__ = 151;
      validate_non_negative_index("nu", "n * (n_lfo == n)", nu_2dim__);
      current_statement__ = 152;
      y_fit_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 152;
      y_fit_1dim__ = (n * logical_eq(n_lfo, n));
      current_statement__ = 152;
      validate_non_negative_index("y_fit", "n * (n_lfo == n)", y_fit_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += k_fixed;
      num_params_r__ += k_rw1;
      num_params_r__ += k_rw2;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_walker_lm_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> beta_fixed;
      beta_fixed = Eigen::Matrix<local_scalar_t__, -1, 1>(k_fixed);
      stan::math::fill(beta_fixed, DUMMY_VAR__);
      
      current_statement__ = 1;
      beta_fixed = in__.vector(k_fixed);
      std::vector<local_scalar_t__> sigma_rw1;
      sigma_rw1 = std::vector<local_scalar_t__>(k_rw1, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
        current_statement__ = 2;
        assign(sigma_rw1, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_rw1");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(sigma_rw1, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_rw1[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma_rw1");
        } else {
          current_statement__ = 2;
          assign(sigma_rw1, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_rw1[(sym1__ - 1)], 0),
            "assigning variable sigma_rw1");
        }}
      std::vector<local_scalar_t__> sigma_rw2;
      sigma_rw2 = std::vector<local_scalar_t__>(k_rw2, DUMMY_VAR__);
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
        current_statement__ = 3;
        assign(sigma_rw2, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_rw2");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
        current_statement__ = 3;
        if (jacobian__) {
          current_statement__ = 3;
          assign(sigma_rw2, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_rw2[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma_rw2");
        } else {
          current_statement__ = 3;
          assign(sigma_rw2, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_rw2[(sym1__ - 1)], 0),
            "assigning variable sigma_rw2");
        }}
      local_scalar_t__ sigma_y;
      sigma_y = DUMMY_VAR__;
      
      current_statement__ = 4;
      sigma_y = in__.scalar();
      current_statement__ = 4;
      if (jacobian__) {
        current_statement__ = 4;
        sigma_y = stan::math::lb_constrain(sigma_y, 0, lp__);
      } else {
        current_statement__ = 4;
        sigma_y = stan::math::lb_constrain(sigma_y, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> log_lik;
      log_lik = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
      stan::math::fill(log_lik, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> Rt;
      Rt = Eigen::Matrix<local_scalar_t__, -1, -1>(m, n);
      stan::math::fill(Rt, DUMMY_VAR__);
      
      current_statement__ = 6;
      assign(Rt, nil_index_list(), rep_matrix(0.0, m, n),
        "assigning variable Rt");
      Eigen::Matrix<local_scalar_t__, -1, 1> xbeta;
      xbeta = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
      stan::math::fill(xbeta, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> y_;
      y_ = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
      stan::math::fill(y_, DUMMY_VAR__);
      
      current_statement__ = 13;
      if (logical_gt(k_fixed, 0)) {
        current_statement__ = 11;
        assign(xbeta, nil_index_list(), multiply(xreg_fixed, beta_fixed),
          "assigning variable xbeta");
      } else {
        current_statement__ = 9;
        assign(xbeta, nil_index_list(), rep_vector(0.0, n),
          "assigning variable xbeta");
      }
      current_statement__ = 14;
      assign(y_, nil_index_list(), subtract(y, xbeta),
        "assigning variable y_");
      current_statement__ = 22;
      for (int t = 1; t <= n; ++t) {
        current_statement__ = 17;
        for (int i = 1; i <= k_rw1; ++i) {
          current_statement__ = 15;
          assign(Rt,
            cons_list(index_uni(i),
              cons_list(index_uni(t), nil_index_list())),
            pow(
              (rvalue(gamma_rw1,
                 cons_list(index_uni(i),
                   cons_list(index_uni(t), nil_index_list())), "gamma_rw1") *
                sigma_rw1[(i - 1)]), 2), "assigning variable Rt");}
        current_statement__ = 20;
        for (int i = 1; i <= k_rw2; ++i) {
          current_statement__ = 18;
          assign(Rt,
            cons_list(index_uni((k + i)),
              cons_list(index_uni(t), nil_index_list())),
            pow(
              (rvalue(gamma_rw2,
                 cons_list(index_uni(i),
                   cons_list(index_uni(t), nil_index_list())), "gamma_rw2") *
                sigma_rw2[(i - 1)]), 2), "assigning variable Rt");}}
      current_statement__ = 23;
      assign(log_lik, nil_index_list(),
        gaussian_filter(y_, y_miss, a1, P1, pow(sigma_y, 2), Tt, Rt, xreg_rw,
          gamma2_y, pstream__), "assigning variable log_lik");
      {
        current_statement__ = 60;
        lp_accum__.add(
          normal_lpdf<propto__>(beta_fixed, beta_fixed_mean, beta_fixed_sd));
        current_statement__ = 61;
        lp_accum__.add(
          gamma_lpdf<propto__>(sigma_y, sigma_y_shape, sigma_y_rate));
        current_statement__ = 62;
        lp_accum__.add(
          gamma_lpdf<propto__>(sigma_rw1, sigma_rw1_shape, sigma_rw1_rate));
        current_statement__ = 63;
        lp_accum__.add(
          gamma_lpdf<propto__>(sigma_rw2, sigma_rw2_shape, sigma_rw2_rate));
        current_statement__ = 64;
        lp_accum__.add(
          sum(
            rvalue(log_lik,
              cons_list(index_multi(obs_idx), nil_index_list()), "log_lik")));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_walker_lm_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> beta_fixed;
      beta_fixed = Eigen::Matrix<double, -1, 1>(k_fixed);
      stan::math::fill(beta_fixed, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      beta_fixed = in__.vector(k_fixed);
      std::vector<double> sigma_rw1;
      sigma_rw1 = std::vector<double>(k_rw1, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
        current_statement__ = 2;
        assign(sigma_rw1, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_rw1");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
        current_statement__ = 2;
        assign(sigma_rw1, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma_rw1[(sym1__ - 1)], 0),
          "assigning variable sigma_rw1");}
      std::vector<double> sigma_rw2;
      sigma_rw2 = std::vector<double>(k_rw2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
        current_statement__ = 3;
        assign(sigma_rw2, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_rw2");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
        current_statement__ = 3;
        assign(sigma_rw2, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma_rw2[(sym1__ - 1)], 0),
          "assigning variable sigma_rw2");}
      double sigma_y;
      sigma_y = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma_y = in__.scalar();
      current_statement__ = 4;
      sigma_y = stan::math::lb_constrain(sigma_y, 0);
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> Rt;
      Rt = Eigen::Matrix<double, -1, -1>(m, n);
      stan::math::fill(Rt, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> xbeta;
      xbeta = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(xbeta, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> y_;
      y_ = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(y_, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
        vars__.emplace_back(beta_fixed[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
        vars__.emplace_back(sigma_rw1[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
        vars__.emplace_back(sigma_rw2[(sym1__ - 1)]);}
      vars__.emplace_back(sigma_y);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 6;
      assign(Rt, nil_index_list(), rep_matrix(0.0, m, n),
        "assigning variable Rt");
      current_statement__ = 13;
      if (logical_gt(k_fixed, 0)) {
        current_statement__ = 11;
        assign(xbeta, nil_index_list(), multiply(xreg_fixed, beta_fixed),
          "assigning variable xbeta");
      } else {
        current_statement__ = 9;
        assign(xbeta, nil_index_list(), rep_vector(0.0, n),
          "assigning variable xbeta");
      }
      current_statement__ = 14;
      assign(y_, nil_index_list(), subtract(y, xbeta),
        "assigning variable y_");
      current_statement__ = 22;
      for (int t = 1; t <= n; ++t) {
        current_statement__ = 17;
        for (int i = 1; i <= k_rw1; ++i) {
          current_statement__ = 15;
          assign(Rt,
            cons_list(index_uni(i),
              cons_list(index_uni(t), nil_index_list())),
            pow(
              (rvalue(gamma_rw1,
                 cons_list(index_uni(i),
                   cons_list(index_uni(t), nil_index_list())), "gamma_rw1") *
                sigma_rw1[(i - 1)]), 2), "assigning variable Rt");}
        current_statement__ = 20;
        for (int i = 1; i <= k_rw2; ++i) {
          current_statement__ = 18;
          assign(Rt,
            cons_list(index_uni((k + i)),
              cons_list(index_uni(t), nil_index_list())),
            pow(
              (rvalue(gamma_rw2,
                 cons_list(index_uni(i),
                   cons_list(index_uni(t), nil_index_list())), "gamma_rw2") *
                sigma_rw2[(i - 1)]), 2), "assigning variable Rt");}}
      current_statement__ = 23;
      assign(log_lik, nil_index_list(),
        gaussian_filter(y_, y_miss, a1, P1, pow(sigma_y, 2), Tt, Rt, xreg_rw,
          gamma2_y, pstream__), "assigning variable log_lik");
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          vars__.emplace_back(log_lik[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= m; ++sym2__) {
            vars__.emplace_back(
              rvalue(Rt,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "Rt"));}}
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          vars__.emplace_back(xbeta[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          vars__.emplace_back(y_[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, 1> y_rep;
      y_rep = Eigen::Matrix<double, -1, 1>(y_rep_1dim__);
      stan::math::fill(y_rep, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> beta_rw;
      beta_rw = Eigen::Matrix<double, -1, -1>(k, beta_rw_2dim__);
      stan::math::fill(beta_rw, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> nu;
      nu = Eigen::Matrix<double, -1, -1>(k_rw2, nu_2dim__);
      stan::math::fill(nu, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> y_fit;
      y_fit = Eigen::Matrix<double, -1, 1>(y_fit_1dim__);
      stan::math::fill(y_fit, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 59;
      if (logical_eq(n_lfo, n)) {
        current_statement__ = 30;
        for (int i = 1; i <= k_rw1; ++i) {
          current_statement__ = 28;
          assign(beta_rw,
            cons_list(index_uni(i),
              cons_list(index_uni(1), nil_index_list())),
            normal_rng(beta_rw1_mean, beta_rw1_sd, base_rng__),
            "assigning variable beta_rw");}
        current_statement__ = 34;
        for (int i = 1; i <= k_rw2; ++i) {
          current_statement__ = 31;
          assign(beta_rw,
            cons_list(index_uni((k_rw1 + i)),
              cons_list(index_uni(1), nil_index_list())),
            normal_rng(beta_rw2_mean, beta_rw2_sd, base_rng__),
            "assigning variable beta_rw");
          current_statement__ = 32;
          assign(nu,
            cons_list(index_uni(i),
              cons_list(index_uni(1), nil_index_list())),
            normal_rng(nu_mean, nu_sd, base_rng__), "assigning variable nu");
        }
        current_statement__ = 43;
        for (int t = 1; t <= (n - 1); ++t) {
          current_statement__ = 37;
          for (int i = 1; i <= k_rw1; ++i) {
            current_statement__ = 35;
            assign(beta_rw,
              cons_list(index_uni(i),
                cons_list(index_uni((t + 1)), nil_index_list())),
              normal_rng(
                rvalue(beta_rw,
                  cons_list(index_uni(i),
                    cons_list(index_uni(t), nil_index_list())), "beta_rw"),
                (rvalue(gamma_rw1,
                   cons_list(index_uni(i),
                     cons_list(index_uni(t), nil_index_list())), "gamma_rw1")
                  * sigma_rw1[(i - 1)]), base_rng__),
              "assigning variable beta_rw");}
          current_statement__ = 41;
          for (int i = 1; i <= k_rw2; ++i) {
            current_statement__ = 38;
            assign(beta_rw,
              cons_list(index_uni((k_rw1 + i)),
                cons_list(index_uni((t + 1)), nil_index_list())),
              (rvalue(beta_rw,
                 cons_list(index_uni((k_rw1 + i)),
                   cons_list(index_uni(t), nil_index_list())), "beta_rw") +
                rvalue(nu,
                  cons_list(index_uni(i),
                    cons_list(index_uni(t), nil_index_list())), "nu")),
              "assigning variable beta_rw");
            current_statement__ = 39;
            assign(nu,
              cons_list(index_uni(i),
                cons_list(index_uni((t + 1)), nil_index_list())),
              normal_rng(
                rvalue(nu,
                  cons_list(index_uni(i),
                    cons_list(index_uni(t), nil_index_list())), "nu"),
                (rvalue(gamma_rw2,
                   cons_list(index_uni(i),
                     cons_list(index_uni(t), nil_index_list())), "gamma_rw2")
                  * sigma_rw2[(i - 1)]), base_rng__), "assigning variable nu");
          }}
        current_statement__ = 46;
        for (int t = 1; t <= n; ++t) {
          current_statement__ = 44;
          assign(y_rep, cons_list(index_uni(t), nil_index_list()),
            normal_rng(
              dot_product(
                rvalue(xreg_rw,
                  cons_list(index_omni(),
                    cons_list(index_uni(t), nil_index_list())), "xreg_rw"),
                rvalue(beta_rw,
                  cons_list(index_omni(),
                    cons_list(index_uni(t), nil_index_list())), "beta_rw")),
              (gamma_y[(t - 1)] * sigma_y), base_rng__),
            "assigning variable y_rep");}
        {
          current_statement__ = 47;
          validate_non_negative_index("states", "m", m);
          current_statement__ = 48;
          validate_non_negative_index("states", "n", n);
          Eigen::Matrix<double, -1, -1> states;
          states = Eigen::Matrix<double, -1, -1>(m, n);
          stan::math::fill(states, std::numeric_limits<double>::quiet_NaN());
          
          current_statement__ = 49;
          assign(states, nil_index_list(),
            gaussian_smoother(subtract(y_, y_rep), y_miss, a1, P1,
              pow(sigma_y, 2), Tt, Rt, xreg_rw, gamma2_y, pstream__),
            "assigning variable states");
          current_statement__ = 50;
          assign(beta_rw, nil_index_list(),
            add(stan::model::deep_copy(beta_rw),
              rvalue(states,
                cons_list(index_min_max(1, k),
                  cons_list(index_min_max(1, n), nil_index_list())),
                "states")), "assigning variable beta_rw");
          current_statement__ = 52;
          if (logical_gt(k_rw2, 0)) {
            current_statement__ = 51;
            assign(nu, nil_index_list(),
              add(stan::model::deep_copy(nu),
                rvalue(states,
                  cons_list(index_min_max((k + 1), m),
                    cons_list(index_min_max(1, n), nil_index_list())),
                  "states")), "assigning variable nu");
          } 
        }
        current_statement__ = 57;
        for (int t = 1; t <= n; ++t) {
          current_statement__ = 54;
          assign(y_fit, cons_list(index_uni(t), nil_index_list()),
            (xbeta[(t - 1)] +
              dot_product(
                rvalue(xreg_rw,
                  cons_list(index_omni(),
                    cons_list(index_uni(t), nil_index_list())), "xreg_rw"),
                rvalue(beta_rw,
                  cons_list(index_omni(),
                    cons_list(index_uni(t), nil_index_list())), "beta_rw"))),
            "assigning variable y_fit");
          current_statement__ = 55;
          assign(y_rep, cons_list(index_uni(t), nil_index_list()),
            normal_rng(y_fit[(t - 1)], (gamma_y[(t - 1)] * sigma_y),
              base_rng__), "assigning variable y_rep");}
      } 
      for (int sym1__ = 1; sym1__ <= y_rep_1dim__; ++sym1__) {
        vars__.emplace_back(y_rep[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= beta_rw_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
          vars__.emplace_back(
            rvalue(beta_rw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "beta_rw"));
        }}
      for (int sym1__ = 1; sym1__ <= nu_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= k_rw2; ++sym2__) {
          vars__.emplace_back(
            rvalue(nu,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "nu"));}}
      for (int sym1__ = 1; sym1__ <= y_fit_1dim__; ++sym1__) {
        vars__.emplace_back(y_fit[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> beta_fixed;
      beta_fixed = Eigen::Matrix<double, -1, 1>(k_fixed);
      stan::math::fill(beta_fixed, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_fixed_flat__;
        current_statement__ = 1;
        assign(beta_fixed_flat__, nil_index_list(),
          context__.vals_r("beta_fixed"),
          "assigning variable beta_fixed_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
          current_statement__ = 1;
          assign(beta_fixed, cons_list(index_uni(sym1__), nil_index_list()),
            beta_fixed_flat__[(pos__ - 1)], "assigning variable beta_fixed");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      std::vector<double> sigma_rw1;
      sigma_rw1 = std::vector<double>(k_rw1, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      assign(sigma_rw1, nil_index_list(), context__.vals_r("sigma_rw1"),
        "assigning variable sigma_rw1");
      std::vector<double> sigma_rw1_free__;
      sigma_rw1_free__ = std::vector<double>(k_rw1, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
        current_statement__ = 2;
        assign(sigma_rw1_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma_rw1[(sym1__ - 1)], 0),
          "assigning variable sigma_rw1_free__");}
      std::vector<double> sigma_rw2;
      sigma_rw2 = std::vector<double>(k_rw2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      assign(sigma_rw2, nil_index_list(), context__.vals_r("sigma_rw2"),
        "assigning variable sigma_rw2");
      std::vector<double> sigma_rw2_free__;
      sigma_rw2_free__ = std::vector<double>(k_rw2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
        current_statement__ = 3;
        assign(sigma_rw2_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma_rw2[(sym1__ - 1)], 0),
          "assigning variable sigma_rw2_free__");}
      double sigma_y;
      sigma_y = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma_y = context__.vals_r("sigma_y")[(1 - 1)];
      double sigma_y_free__;
      sigma_y_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma_y_free__ = stan::math::lb_free(sigma_y, 0);
      for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
        vars__.emplace_back(beta_fixed[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
        vars__.emplace_back(sigma_rw1_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
        vars__.emplace_back(sigma_rw2_free__[(sym1__ - 1)]);}
      vars__.emplace_back(sigma_y_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("beta_fixed");
    names__.emplace_back("sigma_rw1");
    names__.emplace_back("sigma_rw2");
    names__.emplace_back("sigma_y");
    names__.emplace_back("log_lik");
    names__.emplace_back("Rt");
    names__.emplace_back("xbeta");
    names__.emplace_back("y_");
    names__.emplace_back("y_rep");
    names__.emplace_back("beta_rw");
    names__.emplace_back("nu");
    names__.emplace_back("y_fit");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k_fixed)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k_rw1)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k_rw2)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(m),
                                             static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(y_rep_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k),
                                             static_cast<size_t>(beta_rw_2dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k_rw2),
                                             static_cast<size_t>(nu_2dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(y_fit_1dim__)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta_fixed" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_rw1" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_rw2" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma_y");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= m; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Rt" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "xbeta" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= y_rep_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_rep" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= beta_rw_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta_rw" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nu_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= k_rw2; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "nu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= y_fit_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_fit" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta_fixed" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_rw1" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_rw2" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma_y");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= m; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Rt" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "xbeta" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= y_rep_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_rep" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= beta_rw_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta_rw" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nu_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= k_rw2; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "nu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= y_fit_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_fit" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta_fixed\",\"type\":{\"name\":\"vector\",\"length\":" << k_fixed << "},\"block\":\"parameters\"},{\"name\":\"sigma_rw1\",\"type\":{\"name\":\"array\",\"length\":" << k_rw1 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_rw2\",\"type\":{\"name\":\"array\",\"length\":" << k_rw2 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_y\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"Rt\",\"type\":{\"name\":\"matrix\",\"rows\":" << m << ",\"cols\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"xbeta\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"y_\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"y_rep\",\"type\":{\"name\":\"vector\",\"length\":" << y_rep_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"beta_rw\",\"type\":{\"name\":\"matrix\",\"rows\":" << k << ",\"cols\":" << beta_rw_2dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"nu\",\"type\":{\"name\":\"matrix\",\"rows\":" << k_rw2 << ",\"cols\":" << nu_2dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"y_fit\",\"type\":{\"name\":\"vector\",\"length\":" << y_fit_1dim__ << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta_fixed\",\"type\":{\"name\":\"vector\",\"length\":" << k_fixed << "},\"block\":\"parameters\"},{\"name\":\"sigma_rw1\",\"type\":{\"name\":\"array\",\"length\":" << k_rw1 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_rw2\",\"type\":{\"name\":\"array\",\"length\":" << k_rw2 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_y\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"Rt\",\"type\":{\"name\":\"matrix\",\"rows\":" << m << ",\"cols\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"xbeta\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"y_\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"y_rep\",\"type\":{\"name\":\"vector\",\"length\":" << y_rep_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"beta_rw\",\"type\":{\"name\":\"matrix\",\"rows\":" << k << ",\"cols\":" << beta_rw_2dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"nu\",\"type\":{\"name\":\"matrix\",\"rows\":" << k_rw2 << ",\"cols\":" << nu_2dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"y_fit\",\"type\":{\"name\":\"vector\",\"length\":" << y_fit_1dim__ << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_walker_lm_namespace::model_walker_lm;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_walker_lm_namespace::profiles__;
}
#endif
#endif
