% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkwavs.R
\name{checkwavs}
\alias{checkwavs}
\title{Check .wav files}
\usage{
checkwavs(X = NULL, path = NULL)
}
\arguments{
\item{X}{Optional. 'selection.table' object or data frame with the following columns: 1) "sound.files": name of the .wav 
files, 2) "sel": number of the selections, 3) "start": start time of selections, 4) "end": 
end time of selections. The ouptut of \code{\link{manualoc}} or \code{\link{autodetec}} can 
be used as the input data frame. If provided the function also returns the
smallest number of samples from the listed selections, which limits the minimum window 
length (wl argument in other functions) that can be used in batch analyses. 
This could be useful for avoiding errors in dowstream functions (e.g. \code{\link{specan}}).}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}
}
\value{
If all .wav files are ok, returns message "All files can be read".
  Otherwise returns the names of the corrupted .wav files.
}
\description{
\code{checkwavs} checks whether .wav files can be read by subsequent functions.
}
\details{
This function checks if .wav files in the working directory can be read.
Users must set the working directory where they wish to check .wav files beforehand. 
If X is provided it also returns the smallest number of samples from
the selections listed in X (if all files can be read). Note that corrupt files can be
fixed using \code{\link{fixwavs}}) ('sox' must be installed to be able to run this function).
The function is intended for a "quick and dirty" check of the .wav files in a selections data
 frame. For a more thourough analysis see \code{\link{checksels}}.
}
\examples{
{
# First set temporary folder
# setwd(tempdir())

# save wav file examples
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "selec.table"))
writeWave(Phae.long1,"Phae.long1.wav")
writeWave(Phae.long2,"Phae.long2.wav")
writeWave(Phae.long3,"Phae.long3.wav")
writeWave(Phae.long4,"Phae.long4.wav")

# without selection data frame
checkwavs()

# without selection data frame
checkwavs(X = selec.table)
}
}
\seealso{
\code{\link{checksels}} \code{\link{seltailor}}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
