% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_DTW.R
\name{multi_DTW}
\alias{multi_DTW}
\title{A wrapper on \code{\link[dtw]{dtwDist}} for comparing multivariate contours}
\usage{
multi_DTW(ts.df1 = NULL, ts.df2 = NULL, pb = TRUE,  parallel = 1, 
window.type = "none", open.end = FALSE, scale = FALSE, dist.mat = TRUE, ...)
}
\arguments{
\item{ts.df1}{Optional. Data frame with frequency contour time series of signals to be compared.}

\item{ts.df2}{Optional. Data frame with frequency contour time series of signals to be compared.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}. Note that progress bar is only used
when parallel = 1.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing). Not availble in Windows OS.}

\item{window.type}{\code{\link[dtw]{dtw}} windowing control parameter. Character: "none", "itakura", or a function (see \code{\link[dtw]{dtw}}).}

\item{open.end}{\code{\link[dtw]{dtw}} control parameter. Performs 
open-ended alignments (see \code{\link[dtw]{dtw}}).}

\item{scale}{Logical. If \code{TRUE} dominant frequency values are z-transformed using the \code{\link[base]{scale}} function, which "ignores" differences in absolute frequencies between the signals in order to focus the 
comparison in the frequency contour, regardless of the pitch of signals. Default is \code{TRUE}.}

\item{dist.mat}{Logical controlling whether a distance matrix (\code{TRUE}, 
default) or a tabular data frame (\code{FALSE}) is returned.}

\item{...}{Additional arguments to be passed to \code{\link{trackfreqs}} for customizing
graphical output.}
}
\value{
A matrix with the pairwise dissimilarity values. If img is 
\code{FALSE} it also produces image files with the spectrograms of the signals listed in the 
input data frame showing the location of the dominant frequencies.
}
\description{
\code{multi_DTW} is a wrapper on \code{\link[dtw]{dtwDist}} that simplify applying dynamic time warping on multivariate contours.
}
\details{
This function extracts the dominant frequency values as a time series and
 then calculates the pairwise acoustic dissimilarity using dynamic time warping.
The function uses the \code{\link[stats]{approx}} function to interpolate values between dominant
 frequency  measures. If 'img' is  \code{TRUE} the function also produces image files
 with the spectrograms of the signals listed in the input data frame showing the
 location of the dominant frequencies.
}
\examples{
\dontrun{
#load data
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "selec.table"))

writeWave(Phae.long1, "Phae.long1.wav") #save sound files 
writeWave(Phae.long2, "Phae.long2.wav")
writeWave(Phae.long3, "Phae.long3.wav")
writeWave(Phae.long4, "Phae.long4.wav")

# measure
df <- df_ts(X = selec.table, threshold = 10, img = FALSE)
se <- se_ts(X = selec.table, threshold = 10, img = FALSE)

# run function 
multi_DTW(df, se)
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{specreator}} for creating spectrograms from selections,
 \code{\link{snrspecs}} for creating spectrograms to 
  optimize noise margins used in \code{\link{sig2noise}} and \code{\link{dfts}}, \code{\link{ffts}}, \code{\link{ffDTW}} for frequency contour overlaid spectrograms.
 \href{https://marce10.github.io/2016/09/12/Similarity_of_acoustic_signals_with_dynamic_time_warping_(DTW).html}{blog post on DTW similarity}

Other spectrogram creators: \code{\link{color.spectro}},
  \code{\link{dfDTW}}, \code{\link{dfts}},
  \code{\link{ffDTW}}, \code{\link{ffts}},
  \code{\link{phylo_spectro}}, \code{\link{snrspecs}},
  \code{\link{sp.en.ts}}, \code{\link{specreator}},
  \code{\link{trackfreqs}}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
\concept{spectrogram creators}
