% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovlp_sels.R
\name{ovlp_sels}
\alias{ovlp_sels}
\title{Find overlapping selections}
\usage{
ovlp_sels(X, index = FALSE, pb = TRUE, max.ovlp = 0, relabel = FALSE, 
drop = FALSE, priority = NULL, priority.col = NULL, unique.labs = TRUE, 
indx.row = FALSE, parallel = 1)
}
\arguments{
\item{X}{'selection_table' object or data frame with the following columns: 1) "sound.files": name of the .wav 
files, 2) "selec": number of the selections, 3) "start": start time of selections, 4) "end": 
end time of selections. The output of \code{\link{manualoc}} or \code{\link{autodetec}} can 
be used as the input data frame. Other data frames can be used as input, but must have at least the 4 columns mentioned above.}

\item{index}{Logical. Indicates if only the index of the overlapping selections would be returned.
Default is \code{FALSE}.}

\item{pb}{Logical argument to control progress bar and messages. Default is \code{TRUE}.}

\item{max.ovlp}{Numeric vector of length 1 specifying the maximum overlap allowed (in seconds)
. Default is 0.}

\item{relabel}{Logical. If \code{TRUE} then selections names (selec column) are reset within each sound files.
Default is \code{FALSE}.}

\item{drop}{Logical. If \code{TRUE}, when 2 or more selections overlap the function will remove 
all but one of the overlapping selection. Default is \code{FALSE}.}

\item{priority}{Character vector. Controls the priority criteria used for removing overlapped selections. It
must list the levels of the column used to determine priority (argument priority.col) in the desired 
priority order. Default is \code{NULL}.}

\item{priority.col}{Character vector of length 1 with the name of the column use to determine the priority of
overlapped selections. Default is \code{NULL}.}

\item{unique.labs}{Logical to control if labels are reused across different sound files (if \code{TRUE}, default).}

\item{indx.row}{Logical. If \code{TRUE} then a character column with the indices of all selections that overlapped with
each selection is added to the ouput data frame (if \code{index = TRUE}). For instance, if the selections in rows 1,2 
and 3 all overlapped with each other, the 'indx.row' value would be "1/2/3" for all. However, if selection 3 only overlaps
 with 2 but not with 1, then it returns, "1/2" for row 1, "1/2/3" for row 2, and "2/3" for row 3. Default is \code{FALSE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}
}
\value{
A data frame with the columns in X plus an additional column ('ovlp_sels') indicating 
which selections overlap. The ones with the same number overlap with each other. If 
\code{drop = TRUE} only the non-overlapping selections are return. If 2 or more selections 
overlap only the first one is kept.
}
\description{
\code{ovlp_sels} finds which selections overlap in time within a given sound file.
}
\details{
This function detects selections within a selection table that overlap in time. Selections must be 
listed in a data frame similar to \code{\link{lbh_selec_table}}. Note that row names are set to \code{1:nrow(X)}.
}
\examples{
{
#no overlap
ovlp_sels(X =  lbh_selec_table)

# modified lbh_selec_table to make the first and second selection overlap
Y <- lbh_selec_table
Y$end[4] <- 1.5
  
 ovlp_sels(X =  Y)

# drop overlapping
 ovlp_sels(X =  Y, drop = TRUE)

# get index instead
 ovlp_sels(X =  Y, index = TRUE)
}
}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{filtersels}} \code{\link{lbh_selec_table}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
