% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBillSponsors.R
\name{getBillSponsors}
\alias{getBillSponsors}
\title{Get sponsor information for a bill}
\usage{
getBillSponsors(biennium, billId, paired = TRUE, type = c("df", "list", "xml"))
}
\arguments{
\item{biennium}{Character vector representing the biennium(s) to be
searched. Each argument should take the form "XXXX-YY"}

\item{billId}{Character vector containing the bill(s) to be retrieved.
Each argument should take the form "XX YYYY", where XX
is the prefix (HB, SB, etc.) and YYYY is the bill number.}

\item{paired}{If TRUE, will assume that equal length vectors represent
paired data. Set to FALSE to generate an NxN grid of input
arguments. Applies to equal length vector inputs only.}

\item{type}{One of "df", "list", or "xml". Specifies the format for
the output.}
}
\value{
\code{getBillSponsors} returns an object of type equal to the
\code{type} argument (defaults to dataframe)
}
\description{
Get sponsor information for a bill
}
\examples{
## get the list of all sponsors on a set of bills, filtered for primary sponsorship

spons <- getBillSponsors("2007-08", c("HB 1001", "HB 1002", "HB 1003"))
if(!is.null(spons)) sponsP <- subset(spons, Type == "Primary")
}
