% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dpird_minute.R
\name{get_dpird_minute}
\alias{get_dpird_minute}
\title{Get DPIRD Weather Data by the Minute}
\usage{
get_dpird_minute(
  station_code,
  start_date_time = lubridate::now() - lubridate::hours(24L),
  minutes = 1440L,
  values = "all",
  api_key = get_key(service = "DPIRD")
)
}
\arguments{
\item{station_code}{A \code{character} string or \code{factor} from
\code{\link[=get_stations_metadata]{get_stations_metadata()}} of the \acronym{BOM} station code for the station
of interest.}

\item{start_date_time}{A \code{character} string representing the start date and
time of the query in the format \dQuote{yyyy-mm-dd-hh-mm} (ISO8601).
Defaults to 24 hours before the current local system time, returning the
most recent 24 hour observations rounded to the nearest minute.  This
function does its best to decipher many date and time formats but prefers
ISO8601.}

\item{minutes}{An \code{integer} value that provides the number of observations to
be returned.  Defaults to 1440 minutes for 24 hours of observations.}

\item{values}{A \code{vector} of weather values to query from the
\acronym{API}.  See \strong{Available Values} section for valid available codes.
Defaults to all available values, \code{all}.}

\item{api_key}{A \code{character} string containing your \acronym{API} key from
\acronym{DPIRD}, \url{https://www.agric.wa.gov.au/web-apis}, for the
\acronym{DPIRD} Weather 2.0 \acronym{API}.  Defaults to automatically
detecting your key from your local .Renviron, .Rprofile or similar.
Alternatively, you may directly provide your key as a string here.  If
nothing is provided, you will be prompted on how to set up your \R session
so that it is auto-detected.}
}
\value{
a \code{\link[data.table:data.table]{data.table::data.table()}} with \code{station_code} and the date interval
queried together with the requested weather variables.
}
\description{
Fetch nicely formatted minute weather station data from the \acronym{DPIRD}
Weather 2.0 \acronym{API} for a maximum 24-hour period.
}
\note{
Please note this function converts date-time columns from Coordinated
Universal Time \sQuote{UTC} returned by the \acronym{API} to Australian
Western Standard Time \sQuote{AWST}.
}
\section{Available Values}{

\itemize{
\item all (which will return all of the following values),
\item airTemperature,
\item dateTime,
\item dewPoint,
\item rainfall,
\item relativeHumidity,
\item soilTemperature,
\item solarIrradiance,
\item wetBulb,
\item wind,
\item windAvgSpeed,
\item windMaxSpeed, and
\item windMinSpeed
}
}

\examples{
\dontrun{

# Note that you need to supply your own API key

get_dpird_minute(
  station_code = "SP",
  start_date_time = "2023-02-01 13:00:00",
  minutes = 1440,
  values = c("airTemperature",
             "solarIrradiance",
             "wind"),
  api_key = "your_api_key"
)
}

}
\seealso{
Other DPIRD: 
\code{\link{dpird_extreme_weather_values}},
\code{\link{dpird_minute_values}},
\code{\link{dpird_summary_values}},
\code{\link{find_nearby_stations}()},
\code{\link{find_stations_in}()},
\code{\link{get_dpird_apsim}()},
\code{\link{get_dpird_availability}()},
\code{\link{get_dpird_extremes}()},
\code{\link{get_dpird_summaries}()},
\code{\link{get_stations_metadata}()}

Other data fetching: 
\code{\link{get_ag_bulletin}()},
\code{\link{get_coastal_forecast}()},
\code{\link{get_data_drill}()},
\code{\link{get_data_drill_apsim}()},
\code{\link{get_dpird_apsim}()},
\code{\link{get_dpird_extremes}()},
\code{\link{get_dpird_summaries}()},
\code{\link{get_patched_point}()},
\code{\link{get_patched_point_apsim}()},
\code{\link{get_precis_forecast}()},
\code{\link{get_radar_imagery}()},
\code{\link{get_satellite_imagery}()}
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
\concept{DPIRD}
\concept{data fetching}
