% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etox.R
\name{etox_basic}
\alias{etox_basic}
\title{Get basic information from a ETOX ID}
\usage{
etox_basic(id, verbose = TRUE)
}
\arguments{
\item{id}{character; ETOX ID}

\item{verbose}{logical; print message during processing to console?}
}
\value{
a list wit four entries: cas (the CAS numbers), ec (the EC number),
gsbl (the gsbl number), a data.frame synonys with synonyms and the source url.
}
\description{
Query ETOX: Information System Ecotoxicology and Environmental Quality Targets
\url{https://webetox.uba.de/webETOX/index.do} for basic information
}
\note{
Before using this function, please read the disclaimer
\url{https://webetox.uba.de/webETOX/disclaimer.do}.
}
\examples{
\dontrun{
id <- get_etoxid('Triclosan', mult = 'best')
etox_basic(id)

# Retrieve CAS for multiple inputs
ids <- c("20179", "9051")
sapply(ids, function(y) etox_basic(y)$cas)
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\seealso{
\code{\link{get_etoxid}} to retrieve ETOX IDs, \code{\link{etox_basic}} for basic information,
\code{\link{etox_targets}} for quality targets and \code{\link{etox_tests}} for test results
}

