% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cts.R
\name{cts_compinfo}
\alias{cts_compinfo}
\title{Get record details from Chemical Translation Service (CTS)}
\usage{
cts_compinfo(inchikey, verbose = TRUE)
}
\arguments{
\item{inchikey}{character; InChIkey.}

\item{verbose}{logical; should a verbose output be printed on the console?}
}
\value{
a list of lists (for each supplied inchikey):
a list of 7. inchikey, inchicode, molweight, exactmass, formula, synonyms and externalIds
}
\description{
Get record details from CTS, see \url{http://cts.fiehnlab.ucdavis.edu/}
}
\examples{
\donttest{
# might fail if API is not available
out <- cts_compinfo("XEFQLINVKFYRCS-UHFFFAOYSA-N")
# = Triclosan
str(out)
out[[1]][1:5]

### multiple inputs
inchikeys <- c("XEFQLINVKFYRCS-UHFFFAOYSA-N","BSYNRYMUTXBXSQ-UHFFFAOYSA-N" )
out2 <- cts_compinfo(inchikeys)
str(out2)
# a list of two
# extract molecular weight
sapply(out2, function(y) y$molweight)
}
}
\references{
Wohlgemuth, G., P. K. Haldiya, E. Willighagen, T. Kind, and O. Fiehn 2010The Chemical Translation Service
-- a Web-Based Tool to Improve Standardization of Metabolomic Reports. Bioinformatics 26(20): 2647–2648.
}
\author{
Eduard Szöcs, \email{eduardszoecs@gmail.com}
}
