% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemspider.R
\name{cs_compinfo}
\alias{cs_compinfo}
\title{Retrieve record details by ChemSpider ID}
\usage{
cs_compinfo(csid, fields, apikey = NULL)
}
\arguments{
\item{csid}{numeric; can be obtained using \code{\link{get_csid}}}

\item{fields}{character; see details.}

\item{apikey}{character; your API key. If NULL (default),
\code{cs_check_key()} will look for it in .Renviron or .Rprofile.}
}
\value{
Returns a data frame.
}
\description{
Submit a ChemSpider ID (CSID) and the fields you are interested in, and
retrieve the record details for your query.
}
\details{
Valid values for \code{fields} are \code{"SMILES"},
\code{"Formula"}, \code{"InChI"}, \code{"InChIKey"}, \code{"StdInChI"},
\code{"StdInChIKey"}, \code{"AverageMass"}, \code{"MolecularWeight"},
\code{"MonoisotopicMass"}, \code{"NominalMass"}, \code{"CommonName"},
\code{"ReferenceCount"}, \code{"DataSourceCount"}, \code{"PubMedCount"},
\code{"RSCCount"}, \code{"Mol2D"}, \code{"Mol3D"}. You can specify any
number of fields.
}
\note{
An API key is needed. Register at \url{https://developer.rsc.org/}
for an API key. Please respect the Terms & Conditions. The Terms & Conditions
can be found at \url{https://developer.rsc.org/terms}.
}
\examples{
\dontrun{
cs_compinfo(171, c("SMILES", "CommonName"))
cs_compinfo(171:182, "SMILES")
}
}
\references{
\url{https://developer.rsc.org/compounds-v1/apis}
}
