% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col2lab.R
\name{lab2rgb}
\alias{lab2rgb}
\title{Lab to RGB Conversion}
\usage{
lab2rgb(lab, ref_X = 95.047, ref_Y = 100, ref_Z = 108.883)
}
\arguments{
\item{lab}{}

\item{ref_X, ref_Y, ref_Z}{Reference values for Observer= 2°, Illuminant= D65}
}
\value{
vector of red, green and blue values
}
\description{
Lab colourspace to RGB conversion. Calculated with Observer. = 2°, Illuminant = D65.
}
\details{
The formulas used to convert from Lab to XYZ and XYZ to RGB are from http://www.easyrgb.com/en/math.php and the reference values are from http://www.brucelindbloom.com/index.html?ColorCheckerCalcHelp.html
}
\examples{
lab <- c(100, 0, 0)
lab2rgb(lab)

lab <- col2lab("red")
lab2rgb(lab)
}
\seealso{
Other color: 
\code{\link{col2lab}()},
\code{\link{color_conv}()}
}
\concept{color}
\keyword{internal}
