% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_oval.R
\name{mask_oval}
\alias{mask_oval}
\title{Apply an oval mask to images}
\usage{
mask_oval(stimuli, bounds = NULL, fill = wm_opts("fill"), each = TRUE)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{bounds}{bounds (t, r, b, l) of oval, calculated from templates if NULL}

\item{fill}{background color for mask, see \code{\link[=color_conv]{color_conv()}}}

\item{each}{logical; whether to calculate a mask for each image (default) or just one}
}
\value{
list of stimuli with cropped tems and/or images
}
\description{
Superimpose an oval mask on a set of images.
}
\details{
If the images have templates and \code{bounds = NULL}, the maxiumum and minimum x and y coordinates for each image will be calculated (or the overall max and min if \code{each = FALSE}) and an oval with those dimensions and position will be placed over the face.

If \code{bounds} are set to a list of top, right, bottom and left boundaries, these will be used instead of the boundaries derived from templates.
}
\examples{
# remove external template points and crop
stimuli <- demo_stim() |> subset_tem(features("face")) |> crop_tem(25)

# three styles of mask
omask1 <- mask_oval(stimuli) |> label("default")
omask2 <- mask_oval(stimuli, each = FALSE) |> label("each = FALSE")
omask3 <- mask_oval(stimuli, bounds = list(t= 50, r = 30, b = 40, l = 30)) |> 
  label("manual bounds")

# visualise masks
c(omask1, omask2, omask3) |> plot(nrow = 2, byrow = FALSE)
}
\seealso{
Stimulus manipulation functions
\code{\link{align}()},
\code{\link{crop_tem}()},
\code{\link{crop}()},
\code{\link{greyscale}()},
\code{\link{horiz_eyes}()},
\code{\link{image_func}()},
\code{\link{mask}()},
\code{\link{mirror}()},
\code{\link{pad}()},
\code{\link{resize}()},
\code{\link{rotate}()},
\code{\link{to_size}()}
}
\concept{manipulators}
