% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/websocket.R
\name{WebSocket}
\alias{WebSocket}
\title{Create a WebSocket client}
\arguments{
\item{url}{The WebSocket URL. Should begin with \code{ws://} or \code{wss://}.}

\item{protocols}{Zero or more WebSocket sub-protocol names to offer to the server
during the opening handshake.}

\item{headers}{A named list or character vector representing keys and values
of headers in the initial HTTP request.}

\item{autoConnect}{If set to `FALSE`, then constructing the WebSocket object
will not automatically cause the connection to be established. This can be
used if control will return to R before event handlers can be set on the
WebSocket object (i.e. you are constructing a WebSocket object manually at
an interactive R console); after you are done attaching event handlers, you
must call `ws$connect()` to establish the WebSocket connection.}

\item{accessLogChannels}{A character vector of access log channels that are
  enabled.  Defaults to \code{"none"}, which displays no normal, websocketpp logging activity.
  Setting \code{accessLogChannels = NULL} will use default websocketpp behavior.
  Multiple access logging levels may be passed in for them to be enabled.

  A few commonly used access logging values are:
  \describe{
    \item{\code{"all"}}{Special aggregate value representing "all levels"}
    \item{\code{"none"}}{Special aggregate value representing "no levels"}
    \item{\code{"rerror"}}{Recoverable error. Recovery may mean cleanly closing the connection
          with an appropriate error code to the remote endpoint.}
    \item{\code{"fatal"}}{Unrecoverable error. This error will trigger immediate unclean
          termination of the connection or endpoint.}
  }

  All logging levels are explained in more detail at \url{https://www.zaphoyd.com/websocketpp/manual/reference/logging}.}

\item{errorLogChannels}{A character vector of error log channels that are
  displayed.  The default value is \code{NULL}, which will use default websocketpp behavior.
  Multiple error logging levels may be passed in for them to be enabled.

  A few commonly used error logging values are:
  \describe{
    \item{\code{"all"}}{Special aggregate value representing "all levels"}
    \item{\code{"none"}}{Special aggregate value representing "no levels"}
    \item{\code{"connect"}}{One line for each new connection that is opened}
    \item{\code{"disconnect"}}{One line for each new connection that is closed}
  }

  All logging levels are explained in more detail at \url{https://www.zaphoyd.com/websocketpp/manual/reference/logging}.}

\item{maxMessageSize}{The maximum size of a message in bytes. If a message
larger than this is sent, the connection will fail with the \code{message_too_big}
protocol error.}
}
\description{
\preformatted{
WebSocket$new(url,
  protocols = character(0),
  headers = NULL,
  autoConnect = TRUE,
  accessLogChannels = c("none"),
  errorLogChannels = NULL,
  maxMessageSize = 32 * 1024 * 1024)
}
}
\details{
A WebSocket object has four events you can listen for, by calling the
corresponding `onXXX` method and passing it a callback function. All callback
functions must take a single `event` argument. The `event` argument is a
named list that always contains a `target` element that is the WebSocket
object that originated the event, plus any other relevant data as detailed
below.

\describe{
  \item{\code{onMessage}}{Called each time a message is received from the
    server. The event will have a `data` element, which is the message
    content. If the message is text, the `data` will be a one-element
    character vector; if the message is binary, it will be a raw vector.}
  \item{\code{onOpen}}{Called when the connection is established.}
  \item{\code{onClose}}{Called when a previously-opened connection is closed.
    The event will have `code` (integer) and `reason` (one-element character)
    elements that describe the remote's reason for closing.}
  \item{\code{onError}}{Called when the connection fails to be established.
    The event will have an `message` element, a character vector of length 1
    describing the reason for the error.}
}

Each `onXXX` method can be called multiple times to register multiple
callbacks. Each time an `onXXX` is called, its (invisible) return value is a
function that can be invoked to cancel that particular registration.

A WebSocket object also has the following methods:

\describe{
  \item{\code{connect()}}{Initiates the connection to the server. (This does
    not need to be called unless you have passed `autoConnect=FALSE` to the
    constructor.)}
  \item{\code{send(msg)}}{Sends a message to the server.}
  \item{\code{close()}}{Closes the connection.}
  \item{\code{readyState()}}{Returns an integer representing the state of the
    connection.
    \describe{
      \item{\code{0L}: Connecting}{The WebSocket has not yet established a
      connection with the server.}
      \item{\code{1L}: Open}{The WebSocket has connected and can send and
      receive messages.}
      \item{\code{2L}: Closing}{The WebSocket is in the process of closing.}
      \item{\code{3L}: Closed}{The WebSocket has closed, or failed to open.}
    }}
  \item{setAccessLogChannels(channels)}{Enable the websocket Access channels after the
    websocket's creation.  A value of \code{NULL} will not enable any new Access channels.}
  \item{setErrorLogChannels(channels)}{Enable the websocket Error channels after the
    websocket's creation.  A value of \code{NULL} will not enable any new Error channels.}
  \item{clearAccessLogChannels(channels)}{Disable the websocket Access channels after the
    websocket's creation.  A value of \code{NULL} will not clear any existing Access channels.}
  \item{clearErrorLogChannels(channels)}{Disable the websocket Error channels after the
    websocket's creation.  A value of \code{NULL} will not clear any existing Error channels.}
}
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {

# Create a websocket using the websocket.org test server
ws <- WebSocket$new("ws://echo.websocket.org/")
ws$onMessage(function(event) {
  cat("Client got msg:", event$data, "\n")
})
ws$onClose(function(event) {
  cat("Client disconnected\n")
})
ws$onOpen(function(event) {
  cat("Client connected\n")
})

# Try sending a message with ws$send("hello").
# Close the websocket with ws$close() after you're done with it.
}
}
