% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify.R
\name{classify_visits}
\alias{classify_visits}
\title{Classify visits by matching to a list of classes}
\usage{
classify_visits(
  wt,
  classes,
  match_by = "domain",
  regex_on = NULL,
  return_rows_by = NULL,
  return_rows_val = NULL
)
}
\arguments{
\item{wt}{webtrack data object.}

\item{classes}{a data frame containing classes that can be matched to visits.}

\item{match_by}{character. Whether to match list entries from \code{classes} to
the domain of a visit (\code{"domain"}) or the host (\code{"host"}) with an exact match;
or with a regular expression against the whole URL of a visit (\code{"regex"}).
If set to \code{"domain"} or \code{"host"}, both \code{wt} and \code{classes} need to have
a column called accordingly. If set to \code{"regex"}, the \code{url} column of \code{wt}
will be used, and you need to set \code{regex_on} to the column in \code{classes}
for which to do the pattern matching. Defaults to \code{"domain"}.}

\item{regex_on}{character. Column in \code{classes} which to use for
pattern matching. Defaults to \code{NULL}.}

\item{return_rows_by}{character. A column in \code{classes} on which to
subset the returning data. Defaults to \code{NULL}.}

\item{return_rows_val}{character. The value of the columns specified in
\code{return_rows_by}, for which data should be returned. For example, if your
\code{classes} data contains a column \code{type}, which has a value called \code{"shopping"},
setting \code{return_rows_by} to \code{"type"} and \code{return_rows_val} to \code{"shopping"}
will only return visits classified as \code{"shopping"}.}
}
\value{
webtrack data.frame with the same columns as \code{wt} and any column
in \code{classes} except the column specified by \code{match_by}.
}
\description{
\code{classify_visits()} categorizes visits by either extracting the visit URL's
domain or host and matching them to a list of domains or hosts;
or by matching a list of regular expressions against the visit URL.
}
\examples{
\dontrun{
data("testdt_tracking")
data("domain_list")
wt <- as.wt_dt(testdt_tracking)
# classify visits via domain
wt_domains <- extract_domain(wt)
wt_classes <- classify_visits(wt_domains, classes = domain_list, match_by = "domain")
# classify visits via domain
# for the example, just renaming "domain" column
domain_list$host <- domain_list$domain
wt_hosts <- extract_host(wt)
wt_classes <- classify_visits(wt_hosts, classes = domain_list, match_by = "host")
# classify visits with pattern matching
# for the example, any value in "domain" treated as pattern
data("domain_list")
regex_list <- domain_list[type == "facebook"]
wt_classes <- classify_visits(wt[1:5000],
    classes = regex_list,
    match_by = "regex", regex_on = "domain"
)
# classify visits via domain and only return class "search"
data("domain_list")
wt_classes <- classify_visits(wt_domains,
    classes = domain_list,
    match_by = "domain", return_rows_by = "type",
    return_rows_val = "search"
)
}
}
