% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weco_rules.R
\name{weco.rl}
\alias{weco.rl}
\title{Get running lengths}
\usage{
weco.rl(weco.rst)
}
\arguments{
\item{weco.rst}{A class \code{weco} vector returned from
\code{\link{weco.rule}} or \code{\link{weco.combine}}}
}
\value{
A vector of running lengths detected from the observed continuously
    observed data
}
\description{
Get running lengths
}
\examples{

x        <- rnorm(1000);
rst.comb <- weco.combine(x, lst.rules=list(list(1), list(2, k=9)));
weco.rl(rst.comb);


}
\seealso{
\code{\link{weco.rule}}, \code{\link{weco.combine}}
}

