% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\name{predict_quantile}
\alias{predict_quantile}
\title{Estimation of Quantiles for Parametric Lifetime Distributions}
\usage{
predict_quantile(p, loc_sc_params, distribution = c("weibull",
  "lognormal", "loglogistic", "normal", "logistic", "sev", "weibull3",
  "lognormal3", "loglogistic3"))
}
\arguments{
\item{p}{a numeric vector which consists of failure probabilities
regarding the lifetime data.}

\item{loc_sc_params}{a (named) numeric vector of estimated location
and scale parameters for a specified distribution. The order of
elements is important. First entry needs to be the location
parameter \eqn{\mu} and the second element needs to be the scale
parameter \eqn{\sigma}. If a three-parametric model is used the third element
is the threshold parameter \eqn{\gamma}.}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"}, \code{"loglogistic"},
\code{"normal"}, \code{"logistic"}, \code{"sev"} \emph{(smallest extreme value)},
\code{"weibull3"}, \code{"lognormal3"} or \code{"loglogistic3"}.
Other distributions have not been implemented yet.}
}
\value{
A vector containing the estimated quantiles for a given set of
  failure probabilities and estimated parameters.
}
\description{
This function estimates the quantiles for a given set of estimated
location-scale (and threshold) parameters and specified failure probabilities.
}
\examples{
# Example 1: Predicted quantiles for two-parameter Weibull:
quants <- predict_quantile(p = c(0.01, 0.1, 0.5), loc_sc_params = c(5, 0.5),
                           distribution = "weibull")

# Example 2: Predicted quantiles for three-parameter Weibull:
quants_weib3 <- predict_quantile(p = c(0.01, 0.1, 0.5), loc_sc_params = c(5, 0.5, 10),
                           distribution = "weibull3")
}
