% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{adhdData}
\alias{adhdData}
\title{Children's reaction times (milliseconds) to stimuli of different nature, arranged with
four response columns.}
\format{A data frame with 30 rows and 5 variables:
\describe{
   \item{Group}{whether the child has ADHD or is healty (normal)}.
   \item{TargetAlone}{Reaction time (milliseconds) to a target alone.}
   \item{Congruent}{Reaction time (milliseconds) to a congruent stimulus.}
   \item{Neutral}{Reaction time (milliseconds) to a neutral stimulus.}
   \item{Incongruent}{Reaction time (milliseconds) to an incongruent stimulus.}
}}
\source{
H. J. Keselman, R. R. Wilcox, and L. M. Lix. A generally robust approach to hypothesis testing in
independent and correlated groups designs. Psychophyisiology, 40:586-596, 2003. (Data displayed in page 593).
}
\usage{
adhdData
}
\description{
The data (Keselman et al., 2003) represent the reaction times in milliseconds 
of children with attention-deficit hyperactivity (ADHD) and normal children 
when they are presented four kinds of inputs: 
a target alone or an arrow stimuli incongruent, congruent and neutral to the target. 
According to the authors, the dataset was artificially generated from the summary 
measures given in the original study by Jonkman et al. (1999), in groups of 20 
and 10 children to create an unbalanced design.
}
\examples{
# Assuming a multivariate response
omnibus_LSM_multi <- welchADF.test(adhdData, response = c("TargetAlone", "Congruent",
  "Neutral", "Incongruent"), between.s = "Group", within.s = "multivariate", contrast = "omnibus")
# The same using the S3 method for class formula
omnibus_LSM_multi_form <- welchADF.test(cbind(TargetAlone, Congruent, Neutral, Incongruent)
~ Group, data = adhdData)
  
# Pairwise comparisons of the implicit within-subjects effect present in the multivariate response
pairwise_LSM_multi <- update(omnibus_LSM_multi, contrast = "all.pairwise", effect = "multivariate")
summary(omnibus_LSM_multi)
summary(pairwise_LSM_multi)
}
\references{
L. Jonkman, C. Kemner, M. Verbaten, H. van Engeland, J. Kenemans, G. Camfferman, J. Buitelaar, and
H. Koelega. Perceptual and response interference in children with attention-deficit hyperactivity
disorder, and the effects of methylphenidate. 36(4):419-429, 1999.
}
\keyword{datasets}
