% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/welchADFt-methods.R
\name{confint.welchADFt}
\alias{confint.welchADFt}
\title{Confidence interval for the effect size of model effects}
\usage{
\method{confint}{welchADFt}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{a object of (S3 class) welchADF.t}

\item{parm}{a specification of which parameters are to be given confidence intervals, 
either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{confidence level (completely ignored, since the confidence threshold 
had been in the call to \code{\link{welchADF.test}}).}

\item{...}{additional argument(s) for methods.}
}
\value{
If  \code{effect.size} was set to \code{TRUE} in the call to \code{welchADF.test}, 
  a matrix (or vector) with columns giving lower and upper confidence limits for each parameter. 
  These will be labelled as (1-level)/2 and 1 - (1-level)/2 in % (by default 2.5% and 97.5%).
  If \code{effect.size} was set to \code{FALSE}, \code{NULL} is returned.
}
\description{
For the effects indicated by the user, extracts confidence intervals 
for the effect size from an object of class \code{welchADFt}
returned by a call to \code{\link{welchADF.test}}.
}
\seealso{
\code{\link{welchADF.test}}, \code{\link[stats]{confint.lm}}
}
